/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling;

import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.CrossOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.vertexdegrees.DistinctVertexDegrees;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.PropertyRemover;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.TargetId;
import org.gradoop.flink.model.impl.functions.utils.LeftSide;
import org.gradoop.flink.model.impl.operators.sampling.SamplingAlgorithm;
import org.gradoop.flink.model.impl.operators.sampling.common.SamplingConstants;
import org.gradoop.flink.model.impl.operators.sampling.functions.AddMaxDegreeCrossFunction;
import org.gradoop.flink.model.impl.operators.sampling.functions.NonUniformVertexRandomFilter;
import org.gradoop.flink.model.impl.operators.sampling.functions.VertexToDegreeMap;

public class RandomNonUniformVertexSampling
extends SamplingAlgorithm {
    private final float sampleSize;
    private final long randomSeed;

    public RandomNonUniformVertexSampling(float sampleSize) {
        this(sampleSize, 0L);
    }

    public RandomNonUniformVertexSampling(float sampleSize, long randomSeed) {
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
    }

    @Override
    public LogicalGraph sample(LogicalGraph graph) {
        graph = new DistinctVertexDegrees(SamplingConstants.DEGREE_PROPERTY_KEY, SamplingConstants.IN_DEGREE_PROPERTY_KEY, SamplingConstants.OUT_DEGREE_PROPERTY_KEY, true).execute(graph);
        CrossOperator newVertices = graph.getVertices().map((MapFunction)new VertexToDegreeMap(SamplingConstants.DEGREE_PROPERTY_KEY)).max(0).cross(graph.getVertices()).with((CrossFunction)new AddMaxDegreeCrossFunction("_maxDegree"));
        graph = graph.getFactory().fromDataSets(graph.getGraphHead(), (DataSet<EPGMVertex>)newVertices, graph.getEdges());
        newVertices = graph.getVertices().filter(new NonUniformVertexRandomFilter(this.sampleSize, this.randomSeed, SamplingConstants.DEGREE_PROPERTY_KEY, "_maxDegree"));
        newVertices = newVertices.map(new PropertyRemover(SamplingConstants.DEGREE_PROPERTY_KEY)).map(new PropertyRemover(SamplingConstants.IN_DEGREE_PROPERTY_KEY)).map(new PropertyRemover(SamplingConstants.OUT_DEGREE_PROPERTY_KEY)).map(new PropertyRemover("_maxDegree"));
        JoinOperator.EquiJoin newEdges = graph.getEdges().join((DataSet)newVertices).where(new SourceId()).equalTo(new Id()).with(new LeftSide()).join((DataSet)newVertices).where(new TargetId()).equalTo(new Id()).with(new LeftSide());
        return graph.getFactory().fromDataSets((DataSet<EPGMVertex>)newVertices, (DataSet<EPGMEdge>)newEdges);
    }
}

