/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling;

import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.sampling.RandomEdgeSampling;
import org.gradoop.flink.model.impl.operators.sampling.RandomNonUniformVertexSampling;
import org.gradoop.flink.model.impl.operators.sampling.RandomVertexSampling;
import org.gradoop.flink.model.impl.operators.sampling.SamplingAlgorithm;

public class RandomVertexEdgeSampling
extends SamplingAlgorithm {
    private final VertexEdgeSamplingType vertexEdgeSamplingType;
    private final float vertexSampleSize;
    private final float edgeSampleSize;
    private final long randomSeed;

    public RandomVertexEdgeSampling(float sampleSize) {
        this(sampleSize, sampleSize, 0L, VertexEdgeSamplingType.SimpleVersion);
    }

    public RandomVertexEdgeSampling(float vertexSampleSize, float edgeSampleSize) {
        this(vertexSampleSize, edgeSampleSize, 0L, VertexEdgeSamplingType.SimpleVersion);
    }

    public RandomVertexEdgeSampling(float vertexSampleSize, float edgeSampleSize, VertexEdgeSamplingType vertexEdgeSamplingType) {
        this(vertexSampleSize, edgeSampleSize, 0L, vertexEdgeSamplingType);
    }

    public RandomVertexEdgeSampling(float vertexSampleSize, float edgeSampleSize, long randomSeed, VertexEdgeSamplingType vertexEdgeSamplingType) {
        this.vertexSampleSize = vertexSampleSize;
        this.edgeSampleSize = edgeSampleSize;
        this.randomSeed = randomSeed;
        this.vertexEdgeSamplingType = vertexEdgeSamplingType;
    }

    @Override
    public LogicalGraph sample(LogicalGraph graph) {
        switch (this.vertexEdgeSamplingType) {
            case SimpleVersion: {
                graph = new RandomVertexSampling(this.vertexSampleSize, this.randomSeed).execute(graph);
                graph = new RandomEdgeSampling(this.edgeSampleSize, this.randomSeed).execute(graph);
                break;
            }
            case NonuniformVersion: {
                graph = new RandomNonUniformVertexSampling(this.vertexSampleSize, this.randomSeed).execute(graph);
                graph = new RandomEdgeSampling(this.edgeSampleSize, this.randomSeed).execute(graph);
                break;
            }
            case NonuniformHybridVersion: {
                graph = new RandomNonUniformVertexSampling(this.vertexSampleSize, this.randomSeed).execute(graph);
                graph = new RandomEdgeSampling(1.0f - this.vertexSampleSize, this.randomSeed).execute(graph);
                break;
            }
        }
        return graph;
    }

    public static enum VertexEdgeSamplingType {
        SimpleVersion,
        NonuniformVersion,
        NonuniformHybridVersion;

    }
}

