/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.tuple.Value0Of3;
import org.gradoop.flink.model.impl.operators.sampling.SamplingAlgorithm;
import org.gradoop.flink.model.impl.operators.sampling.functions.EdgeSourceVertexJoin;
import org.gradoop.flink.model.impl.operators.sampling.functions.EdgeTargetVertexJoin;
import org.gradoop.flink.model.impl.operators.sampling.functions.EdgesWithSampledVerticesFilter;
import org.gradoop.flink.model.impl.operators.sampling.functions.FilterVerticesWithDegreeOtherThanGiven;
import org.gradoop.flink.model.impl.operators.sampling.functions.Neighborhood;
import org.gradoop.flink.model.impl.operators.sampling.functions.RandomVertex;

public class RandomVertexNeighborhoodSampling
extends SamplingAlgorithm {
    private final float sampleSize;
    private final long randomSeed;
    private final Neighborhood neighborType;

    public RandomVertexNeighborhoodSampling(float sampleSize) {
        this(sampleSize, 0L);
    }

    public RandomVertexNeighborhoodSampling(float sampleSize, long randomSeed) {
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
        this.neighborType = Neighborhood.BOTH;
    }

    public RandomVertexNeighborhoodSampling(float sampleSize, long randomSeed, Neighborhood neighborType) {
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
        this.neighborType = neighborType;
    }

    public RandomVertexNeighborhoodSampling(float sampleSize, Neighborhood neighborType) {
        this.sampleSize = sampleSize;
        this.randomSeed = 0L;
        this.neighborType = neighborType;
    }

    @Override
    public LogicalGraph sample(LogicalGraph graph) {
        MapOperator sampledVertices = graph.getVertices().map((MapFunction)new RandomVertex(this.sampleSize, this.randomSeed, "sampled"));
        MapOperator newEdges = graph.getEdges().join((DataSet)sampledVertices).where(new SourceId()).equalTo(new Id()).with((JoinFunction)new EdgeSourceVertexJoin("sampled")).join((DataSet)sampledVertices).where(new int[]{1}).equalTo(new Id()).with((JoinFunction)new EdgeTargetVertexJoin("sampled")).filter((FilterFunction)new EdgesWithSampledVerticesFilter(this.neighborType)).map(new Value0Of3());
        graph = graph.getFactory().fromDataSets(graph.getVertices(), (DataSet<EPGMEdge>)newEdges);
        graph = new FilterVerticesWithDegreeOtherThanGiven(0L).execute(graph);
        return graph;
    }
}

