/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.TargetId;
import org.gradoop.flink.model.impl.functions.utils.LeftSide;
import org.gradoop.flink.model.impl.operators.sampling.SamplingAlgorithm;
import org.gradoop.flink.model.impl.operators.sampling.functions.RandomFilter;

public class RandomVertexSampling
extends SamplingAlgorithm {
    private final float sampleSize;
    private final long randomSeed;

    public RandomVertexSampling(float sampleSize) {
        this(sampleSize, 0L);
    }

    public RandomVertexSampling(float sampleSize, long randomSeed) {
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
    }

    @Override
    public LogicalGraph sample(LogicalGraph graph) {
        FilterOperator newVertices = graph.getVertices().filter(new RandomFilter(this.sampleSize, this.randomSeed));
        JoinOperator.EquiJoin newEdges = graph.getEdges().join((DataSet)newVertices).where(new SourceId()).equalTo(new Id()).with(new LeftSide()).join((DataSet)newVertices).where(new TargetId()).equalTo(new Id()).with(new LeftSide());
        return graph.getFactory().fromDataSets((DataSet<EPGMVertex>)newVertices, (DataSet<EPGMEdge>)newEdges);
    }
}

