/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.randomjump.KRandomJumpGellyVCI;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.ByProperty;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.tuple.Value0Of3;
import org.gradoop.flink.model.impl.operators.sampling.SamplingAlgorithm;
import org.gradoop.flink.model.impl.operators.sampling.functions.EdgeSourceVertexJoin;
import org.gradoop.flink.model.impl.operators.sampling.functions.EdgeTargetVertexJoin;
import org.gradoop.flink.model.impl.operators.sampling.functions.EdgesWithSampledVerticesFilter;
import org.gradoop.flink.model.impl.operators.sampling.functions.Neighborhood;

public class RandomWalkSampling
extends SamplingAlgorithm {
    private final float sampleSize;
    private final int numberOfStartVertices;
    private final float jumpProbability;
    private final int maxIteration;

    public RandomWalkSampling(float sampleSize, int numberOfStartVertices) {
        this.sampleSize = sampleSize;
        this.numberOfStartVertices = numberOfStartVertices;
        this.jumpProbability = 0.1f;
        this.maxIteration = Integer.MAX_VALUE;
    }

    public RandomWalkSampling(float sampleSize, int numberOfStartVertices, float jumpProbability, int maxIteration) {
        this.sampleSize = sampleSize;
        this.numberOfStartVertices = numberOfStartVertices;
        this.jumpProbability = jumpProbability;
        this.maxIteration = maxIteration;
    }

    @Override
    protected LogicalGraph sample(LogicalGraph graph) {
        LogicalGraph gellyResult = (LogicalGraph)new KRandomJumpGellyVCI(this.numberOfStartVertices, this.maxIteration, this.jumpProbability, this.sampleSize).execute(graph);
        FilterOperator sampledVertices = gellyResult.getVertices().filter(new ByProperty("sampled"));
        MapOperator sampledEdges = graph.getEdges().join((DataSet)sampledVertices).where(new SourceId()).equalTo(new Id()).with((JoinFunction)new EdgeSourceVertexJoin("sampled")).join((DataSet)sampledVertices).where(new int[]{1}).equalTo(new Id()).with((JoinFunction)new EdgeTargetVertexJoin("sampled")).filter((FilterFunction)new EdgesWithSampledVerticesFilter(Neighborhood.BOTH)).map(new Value0Of3());
        return graph.getFactory().fromDataSets((DataSet<EPGMVertex>)sampledVertices, (DataSet<EPGMEdge>)sampledEdges);
    }
}

