/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling.functions;

import org.apache.flink.api.common.functions.CrossFunction;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;

public class AddPageRankScoresToVertexCrossFunction
implements CrossFunction<EPGMVertex, EPGMGraphHead, EPGMVertex> {
    public EPGMVertex cross(EPGMVertex vertex, EPGMGraphHead graphHead) {
        double min = graphHead.getPropertyValue("min_PageRankScore").getDouble();
        double max = graphHead.getPropertyValue("max_PageRankScore").getDouble();
        double sum = graphHead.getPropertyValue("sum_PageRankScore").getDouble();
        vertex.setProperty("min_PageRankScore", (Object)min);
        vertex.setProperty("max_PageRankScore", (Object)max);
        vertex.setProperty("sum_PageRankScore", (Object)sum);
        vertex.setProperty("vertexCount", graphHead.getPropertyValue("vertexCount"));
        if (min != max) {
            double score = vertex.getPropertyValue("PageRankScore").getDouble();
            vertex.setProperty("scaled_PageRankScore", (Object)((score - min) / (max - min)));
        }
        return vertex;
    }
}

