/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling.functions;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.tuple.Tuple3;
import org.gradoop.common.exceptions.UnsupportedTypeException;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.flink.model.impl.operators.sampling.functions.Neighborhood;

public class EdgesWithSampledVerticesFilter
implements FilterFunction<Tuple3<EPGMEdge, Boolean, Boolean>> {
    private Neighborhood neighborType;

    public EdgesWithSampledVerticesFilter(Neighborhood neighborType) {
        this.neighborType = neighborType;
    }

    public boolean filter(Tuple3<EPGMEdge, Boolean, Boolean> tuple) {
        boolean filter;
        boolean isSourceVertexMarked = (Boolean)tuple.f1;
        boolean isTargetVertexMarked = (Boolean)tuple.f2;
        switch (this.neighborType) {
            case BOTH: {
                filter = isSourceVertexMarked || isTargetVertexMarked;
                break;
            }
            case IN: {
                filter = isTargetVertexMarked;
                break;
            }
            case OUT: {
                filter = isSourceVertexMarked;
                break;
            }
            default: {
                throw new UnsupportedTypeException("NeighborType needs to be BOTH, IN or OUT");
            }
        }
        return filter;
    }
}

