/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling.functions;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.vertexdegrees.DistinctVertexDegrees;
import org.gradoop.flink.model.api.operators.UnaryGraphToGraphOperator;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.PropertyRemover;
import org.gradoop.flink.model.impl.operators.sampling.common.SamplingConstants;
import org.gradoop.flink.model.impl.operators.sampling.functions.VertexWithDegreeFilter;

public class FilterVerticesWithDegreeOtherThanGiven
implements UnaryGraphToGraphOperator {
    private long degree;

    public FilterVerticesWithDegreeOtherThanGiven(long degree) {
        this.degree = degree;
    }

    @Override
    public LogicalGraph execute(LogicalGraph graph) {
        DistinctVertexDegrees distinctVertexDegrees = new DistinctVertexDegrees(SamplingConstants.DEGREE_PROPERTY_KEY, SamplingConstants.IN_DEGREE_PROPERTY_KEY, SamplingConstants.OUT_DEGREE_PROPERTY_KEY, true);
        MapOperator newVertices = distinctVertexDegrees.execute(graph).getVertices().filter(new VertexWithDegreeFilter(this.degree, SamplingConstants.DEGREE_PROPERTY_KEY)).map(new PropertyRemover(SamplingConstants.DEGREE_PROPERTY_KEY)).map(new PropertyRemover(SamplingConstants.IN_DEGREE_PROPERTY_KEY)).map(new PropertyRemover(SamplingConstants.OUT_DEGREE_PROPERTY_KEY));
        return graph.getFactory().fromDataSets(graph.getGraphHead(), (DataSet<EPGMVertex>)newVertices, graph.getEdges());
    }
}

