/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling.functions;

import java.util.Random;
import org.apache.flink.api.common.functions.FilterFunction;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.operators.sampling.functions.VertexDegree;

public class LimitedDegreeVertexRandomFilter<V extends EPGMVertex>
implements FilterFunction<V> {
    private final float threshold;
    private final Random randomGenerator;
    private final long degreeThreshold;
    private final VertexDegree degreeType;

    public LimitedDegreeVertexRandomFilter(float sampleSize, long randomSeed, long degreeThreshold, VertexDegree degreeType) {
        this.threshold = sampleSize;
        this.randomGenerator = randomSeed != 0L ? new Random(randomSeed) : new Random();
        this.degreeThreshold = degreeThreshold;
        this.degreeType = degreeType;
    }

    public boolean filter(V vertex) throws Exception {
        long degree = Long.parseLong(vertex.getPropertyValue(this.degreeType.getName()).toString());
        if (degree > this.degreeThreshold) {
            return true;
        }
        return this.randomGenerator.nextFloat() <= this.threshold;
    }
}

