/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling.functions;

import java.util.Random;
import org.apache.flink.api.common.functions.FilterFunction;
import org.gradoop.common.model.impl.pojo.EPGMVertex;

public class NonUniformVertexRandomFilter<V extends EPGMVertex>
implements FilterFunction<V> {
    private final float threshold;
    private final Random randomGenerator;
    private String propertyNameOfDegree;
    private String propertyNameofMaxDegree;

    public NonUniformVertexRandomFilter(float sampleSize, long randomSeed, String propertyNameOfDegree, String propertyNameOfMaxDegree) {
        this.threshold = sampleSize;
        this.randomGenerator = randomSeed != 0L ? new Random(randomSeed) : new Random();
        this.propertyNameOfDegree = propertyNameOfDegree;
        this.propertyNameofMaxDegree = propertyNameOfMaxDegree;
    }

    public boolean filter(V vertex) throws Exception {
        long degree = vertex.getPropertyValue(this.propertyNameOfDegree).getLong();
        long maxDegree = vertex.getPropertyValue(this.propertyNameofMaxDegree).getLong();
        return (double)this.randomGenerator.nextFloat() <= (double)degree / (double)maxDegree * (double)this.threshold;
    }
}

