/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling.functions;

import org.apache.flink.api.common.functions.FilterFunction;
import org.gradoop.common.model.impl.pojo.EPGMVertex;

public class PageRankResultVertexFilter
implements FilterFunction<EPGMVertex> {
    private final double threshold;
    private final boolean sampleGreaterThanThreshold;
    private final boolean keepVerticesIfSameScore;

    public PageRankResultVertexFilter(double threshold, boolean sampleGreaterThanThreshold, boolean keepVerticesIfSameScore) {
        this.threshold = threshold;
        this.sampleGreaterThanThreshold = sampleGreaterThanThreshold;
        this.keepVerticesIfSameScore = keepVerticesIfSameScore;
    }

    public boolean filter(EPGMVertex v) throws Exception {
        if (v.hasProperty("scaled_PageRankScore")) {
            double pr = v.getPropertyValue("scaled_PageRankScore").getDouble();
            if (this.sampleGreaterThanThreshold) {
                return pr > this.threshold;
            }
            return pr <= this.threshold;
        }
        return this.keepVerticesIfSameScore;
    }
}

