/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling.functions;

import java.util.Random;
import org.apache.flink.api.common.functions.MapFunction;
import org.gradoop.common.model.impl.pojo.EPGMVertex;

public class RandomVertex
implements MapFunction<EPGMVertex, EPGMVertex> {
    private final float sampleSize;
    private final Random randomGenerator;
    private final String samplingKey;

    public RandomVertex(float sampleSize, long randomSeed, String samplingKey) {
        this.samplingKey = samplingKey;
        this.sampleSize = sampleSize;
        this.randomGenerator = randomSeed != 0L ? new Random(randomSeed) : new Random();
    }

    public EPGMVertex map(EPGMVertex vertex) throws Exception {
        if (this.randomGenerator.nextFloat() <= this.sampleSize) {
            vertex.setProperty(this.samplingKey, (Object)true);
        } else {
            vertex.setProperty(this.samplingKey, (Object)false);
        }
        return vertex;
    }
}

