/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.selection;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphCollectionToBaseGraphCollectionOperator;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.graphcontainment.InAnyGraphBroadcast;

public abstract class SelectionBase<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements UnaryBaseGraphCollectionToBaseGraphCollectionOperator<GC> {
    @Override
    public abstract GC execute(GC var1);

    protected GC selectVerticesAndEdges(GC collection, DataSet<G> graphHeads) {
        MapOperator graphIds = graphHeads.map(new Id());
        SingleInputUdfOperator vertices = collection.getVertices().filter(new InAnyGraphBroadcast()).withBroadcastSet((DataSet)graphIds, "graphIds");
        SingleInputUdfOperator edges = collection.getEdges().filter(new InAnyGraphBroadcast()).withBroadcastSet((DataSet)graphIds, "graphIds");
        return collection.getFactory().fromDataSets(graphHeads, vertices, edges);
    }
}

