/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.split.functions;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.common.model.impl.pojo.EPGMEdge;

@FunctionAnnotation.ForwardedFields(value={"f0.id->id;f0.sourceId->sourceId;f0.targetId->targetId;f0.label->label;f0.properties->properties"})
public class AddNewGraphsToEdge<E extends EPGMEdge>
implements FlatMapFunction<Tuple3<E, GradoopIdSet, GradoopIdSet>, E> {
    public void flatMap(Tuple3<E, GradoopIdSet, GradoopIdSet> triple, Collector<E> collector) {
        GradoopIdSet sourceGraphs = (GradoopIdSet)triple.f1;
        GradoopIdSet targetGraphs = (GradoopIdSet)triple.f2;
        GradoopIdSet graphsToBeAdded = new GradoopIdSet();
        boolean filter = false;
        for (GradoopId id : sourceGraphs) {
            if (!targetGraphs.contains((Object)id)) continue;
            graphsToBeAdded.add(id);
            filter = true;
        }
        if (filter) {
            EPGMEdge edge = (EPGMEdge)triple.f0;
            edge.getGraphIds().addAll(graphsToBeAdded);
            collector.collect((Object)edge);
        }
    }
}

