/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.split.functions;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.Function;

@FunctionAnnotation.ForwardedFields(value={"id->f0"})
@FunctionAnnotation.ReadFields(value={"properties"})
public class SplitValues<V extends EPGMVertex>
implements FlatMapFunction<V, Tuple2<GradoopId, PropertyValue>> {
    private Function<V, List<PropertyValue>> function;

    public SplitValues(Function<V, List<PropertyValue>> function) {
        this.function = (Function)Preconditions.checkNotNull(function);
    }

    public void flatMap(V vertex, Collector<Tuple2<GradoopId, PropertyValue>> collector) throws Exception {
        List<PropertyValue> splitValues = this.function.apply(vertex);
        for (PropertyValue value : splitValues) {
            collector.collect((Object)new Tuple2((Object)vertex.getId(), (Object)value));
        }
    }
}

