/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.statistics;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.tuple.Tuple3;
import org.gradoop.flink.algorithms.gelly.connectedcomponents.AnnotateWeaklyConnectedComponents;
import org.gradoop.flink.model.api.operators.UnaryGraphToValueOperator;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.statistics.functions.AggregateListOfWccEdges;
import org.gradoop.flink.model.impl.operators.statistics.functions.AggregateListOfWccVertices;
import org.gradoop.flink.model.impl.operators.statistics.functions.GetConnectedComponentDistributionFlatMap;

public class ConnectedComponentsDistribution
implements UnaryGraphToValueOperator<DataSet<Tuple3<String, Long, Long>>> {
    private final String propertyKey;
    private final int maxIterations;
    private final boolean annotateEdges;

    public ConnectedComponentsDistribution(int maxIterations) {
        this("wcc_component_id", maxIterations, false);
    }

    public ConnectedComponentsDistribution(int maxIterations, boolean annotateEdges) {
        this("wcc_component_id", maxIterations, annotateEdges);
    }

    public ConnectedComponentsDistribution(String propertyKey, int maxIterations) {
        this(propertyKey, maxIterations, false);
    }

    public ConnectedComponentsDistribution(String propertyKey, int maxIterations, boolean annotateEdges) {
        this.propertyKey = propertyKey;
        this.maxIterations = maxIterations;
        this.annotateEdges = annotateEdges;
    }

    @Override
    public DataSet<Tuple3<String, Long, Long>> execute(LogicalGraph graph) {
        LogicalGraph graphWithWccIds = graph.callForGraph(new AnnotateWeaklyConnectedComponents(this.propertyKey, this.maxIterations, this.annotateEdges));
        graphWithWccIds = (LogicalGraph)graphWithWccIds.aggregate(new AggregateListOfWccVertices(this.propertyKey));
        if (this.annotateEdges) {
            graphWithWccIds = (LogicalGraph)graphWithWccIds.aggregate(new AggregateListOfWccEdges(this.propertyKey));
        }
        return graphWithWccIds.getGraphHead().flatMap((FlatMapFunction)new GetConnectedComponentDistributionFlatMap(this.propertyKey, this.annotateEdges));
    }
}

