/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.statistics;

import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.api.operators.UnaryGraphToValueOperator;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.statistics.DegreeCentralityBase;
import org.gradoop.flink.model.impl.operators.statistics.VertexCount;
import org.gradoop.flink.model.impl.operators.statistics.VertexDegrees;
import org.gradoop.flink.model.impl.operators.statistics.functions.CalculateDegreeCentrality;
import org.gradoop.flink.model.impl.operators.statistics.functions.DegreeDistanceFunction;
import org.gradoop.flink.model.impl.tuples.WithCount;

public class DegreeCentrality
extends DegreeCentralityBase
implements UnaryGraphToValueOperator<DataSet<Double>> {
    @Override
    public DataSet<Double> execute(LogicalGraph graph) {
        DataSet<WithCount<GradoopId>> degrees = new VertexDegrees().execute(graph);
        DataSet<Long> vertexCount = new VertexCount().execute(graph);
        AggregateOperator maxDegree = degrees.max(1);
        return ((MapOperator)degrees.map((MapFunction)new DegreeDistanceFunction("degree_max")).withBroadcastSet((DataSet)maxDegree, "degree_max")).sum(0).crossWithTiny(vertexCount).with((CrossFunction)new CalculateDegreeCentrality());
    }
}

