/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.statistics.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.impl.operators.statistics.functions.AggregateListOfWccEdges;
import org.gradoop.flink.model.impl.operators.statistics.functions.AggregateListOfWccVertices;

public class GetConnectedComponentDistributionFlatMap
implements FlatMapFunction<EPGMGraphHead, Tuple3<String, Long, Long>> {
    private final String propertyKey;
    private final boolean annotateEdges;

    public GetConnectedComponentDistributionFlatMap(String propertyKey, boolean annotateEdges) {
        this.propertyKey = propertyKey;
        this.annotateEdges = annotateEdges;
    }

    public void flatMap(EPGMGraphHead graphHead, Collector<Tuple3<String, Long, Long>> out) {
        List vertexWcc = graphHead.getPropertyValue(new AggregateListOfWccVertices(this.propertyKey).getAggregatePropertyKey()).getList().stream().map(PropertyValue::getString).collect(Collectors.toList());
        HashSet distinctComponentIds = new HashSet(vertexWcc);
        List<Object> edgeWcc = new ArrayList();
        if (this.annotateEdges) {
            edgeWcc = graphHead.getPropertyValue(new AggregateListOfWccEdges(this.propertyKey).getAggregatePropertyKey()).getList().stream().map(PropertyValue::getString).collect(Collectors.toList());
        }
        ArrayList finalEdgeWcc = edgeWcc;
        List wccDist = distinctComponentIds.stream().map(wccId -> new Tuple3(wccId, (Object)Collections.frequency(vertexWcc, wccId), (Object)(this.annotateEdges ? (long)Collections.frequency(finalEdgeWcc, wccId) : -1L))).collect(Collectors.toList());
        for (Tuple3 distTuple : wccDist) {
            out.collect((Object)distTuple);
        }
    }
}

