/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.subgraph;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.ApplicableUnaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.TargetId;
import org.gradoop.flink.model.impl.functions.utils.RightSideWithLeftGraphs;
import org.gradoop.flink.model.impl.operators.subgraph.Subgraph;
import org.gradoop.flink.model.impl.operators.subgraph.functions.EdgeToSourceAndTargetIdWithGraphIds;
import org.gradoop.flink.model.impl.operators.subgraph.functions.RightSideWithLeftGraphs2To1;

public class ApplySubgraph<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
extends Subgraph<G, V, E, LG, GC>
implements ApplicableUnaryBaseGraphToBaseGraphOperator<GC> {
    public ApplySubgraph(FilterFunction<V> vertexFilterFunction, FilterFunction<E> edgeFilterFunction, Subgraph.Strategy strategy) {
        super(vertexFilterFunction, edgeFilterFunction, strategy);
    }

    @Override
    public GC executeForGVELayout(GC collection) {
        GC result;
        switch (this.strategy) {
            case BOTH: {
                result = this.subgraph(collection);
                break;
            }
            case VERTEX_INDUCED: {
                result = this.vertexInducedSubgraph(collection);
                break;
            }
            case EDGE_INDUCED: {
                result = this.edgeInducedSubgraph(collection);
                break;
            }
            case EDGE_INDUCED_PROJECT_FIRST: {
                result = this.edgeInducedSubgraphProjectFirst(collection);
                break;
            }
            default: {
                throw new IllegalArgumentException("Strategy " + (Object)((Object)this.strategy) + " is not supported");
            }
        }
        return result;
    }

    @Override
    public GC executeForTxLayout(GC collection) {
        return this.executeForGVELayout(collection);
    }

    private GC vertexInducedSubgraph(GC collection) {
        FilterOperator filteredVertices = collection.getVertices().filter(this.vertexFilterFunction);
        return collection.getFactory().fromDataSets(collection.getGraphHeads(), filteredVertices, collection.getEdges()).verify();
    }

    private GC edgeInducedSubgraph(GC collection) {
        FilterOperator filteredEdges = collection.getEdges().filter(this.edgeFilterFunction);
        DistinctOperator inducedVertices = filteredEdges.join(collection.getVertices()).where(new SourceId()).equalTo(new Id()).with(new RightSideWithLeftGraphs()).union((DataSet)filteredEdges.join(collection.getVertices()).where(new TargetId()).equalTo(new Id()).with(new RightSideWithLeftGraphs())).distinct(new Id());
        return collection.getFactory().fromDataSets(collection.getGraphHeads(), inducedVertices, filteredEdges);
    }

    private GC edgeInducedSubgraphProjectFirst(GC collection) {
        FilterOperator filteredEdges = collection.getEdges().filter(this.edgeFilterFunction);
        JoinOperator.EquiJoin inducedVertices = filteredEdges.flatMap(new EdgeToSourceAndTargetIdWithGraphIds()).distinct(new int[]{0}).join(collection.getVertices()).where(new int[]{0}).equalTo(new Id()).with(new RightSideWithLeftGraphs2To1());
        return collection.getFactory().fromDataSets(collection.getGraphHeads(), inducedVertices, filteredEdges);
    }

    private GC subgraph(GC collection) {
        FilterOperator newVertices = collection.getVertices().filter(this.vertexFilterFunction);
        FilterOperator newEdges = collection.getEdges().filter(this.edgeFilterFunction);
        return collection.getFactory().fromDataSets(collection.getGraphHeads(), newVertices, newEdges);
    }
}

