/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.subgraph;

import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.TargetId;
import org.gradoop.flink.model.impl.functions.utils.RightSide;
import org.gradoop.flink.model.impl.operators.subgraph.functions.EdgeToSourceAndTargetId;

public class Subgraph<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements UnaryBaseGraphToBaseGraphOperator<LG> {
    protected final FilterFunction<V> vertexFilterFunction;
    protected final FilterFunction<E> edgeFilterFunction;
    protected final Strategy strategy;

    public Subgraph(FilterFunction<V> vertexFilterFunction, FilterFunction<E> edgeFilterFunction, Strategy strategy) {
        if (strategy == Strategy.BOTH && (vertexFilterFunction == null || edgeFilterFunction == null)) {
            throw new IllegalArgumentException("No vertex or no edge filter function was given.");
        }
        if (strategy == Strategy.VERTEX_INDUCED && vertexFilterFunction == null) {
            throw new IllegalArgumentException("No vertex filter functions was given.");
        }
        if ((strategy == Strategy.EDGE_INDUCED || strategy == Strategy.EDGE_INDUCED_PROJECT_FIRST) && edgeFilterFunction == null) {
            throw new IllegalArgumentException("No vertex edge functions was given.");
        }
        this.strategy = strategy;
        this.vertexFilterFunction = vertexFilterFunction;
        this.edgeFilterFunction = edgeFilterFunction;
    }

    @Override
    public LG execute(LG superGraph) {
        LG result;
        switch (this.strategy) {
            case BOTH: {
                result = this.subgraph(superGraph);
                break;
            }
            case VERTEX_INDUCED: {
                result = this.vertexInducedSubgraph(superGraph);
                break;
            }
            case EDGE_INDUCED: {
                result = this.edgeInducedSubgraph(superGraph);
                break;
            }
            case EDGE_INDUCED_PROJECT_FIRST: {
                result = this.edgeInducedSubgraphProjectFirst(superGraph);
                break;
            }
            default: {
                throw new IllegalArgumentException("Strategy " + (Object)((Object)this.strategy) + " is not supported");
            }
        }
        return result;
    }

    private LG vertexInducedSubgraph(LG superGraph) {
        FilterOperator filteredVertices = superGraph.getVertices().filter(this.vertexFilterFunction);
        return superGraph.getFactory().fromDataSets(superGraph.getGraphHead(), filteredVertices, superGraph.getEdges()).verify();
    }

    private LG edgeInducedSubgraph(LG superGraph) {
        FilterOperator filteredEdges = superGraph.getEdges().filter(this.edgeFilterFunction);
        DistinctOperator inducedVertices = filteredEdges.join(superGraph.getVertices()).where(new SourceId()).equalTo(new Id()).with(new RightSide()).union((DataSet)filteredEdges.join(superGraph.getVertices()).where(new TargetId()).equalTo(new Id()).with(new RightSide())).distinct(new Id());
        return superGraph.getFactory().fromDataSets(superGraph.getGraphHead(), inducedVertices, filteredEdges);
    }

    private LG edgeInducedSubgraphProjectFirst(LG superGraph) {
        FilterOperator filteredEdges = superGraph.getEdges().filter(this.edgeFilterFunction);
        JoinOperator.EquiJoin inducedVertices = filteredEdges.flatMap(new EdgeToSourceAndTargetId()).distinct().join(superGraph.getVertices()).where(new String[]{"*"}).equalTo(new Id()).with(new RightSide());
        return superGraph.getFactory().fromDataSets(superGraph.getGraphHead(), inducedVertices, filteredEdges);
    }

    private LG subgraph(LG superGraph) {
        return superGraph.getFactory().fromDataSets(superGraph.getGraphHead(), superGraph.getVertices().filter(this.vertexFilterFunction), superGraph.getEdges().filter(this.edgeFilterFunction));
    }

    public static enum Strategy {
        BOTH,
        VERTEX_INDUCED,
        EDGE_INDUCED,
        EDGE_INDUCED_PROJECT_FIRST;

    }
}

