/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.tostring;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphCollectionToValueOperator;
import org.gradoop.flink.model.impl.functions.epgm.LabelCombiner;
import org.gradoop.flink.model.impl.operators.tostring.api.EdgeToString;
import org.gradoop.flink.model.impl.operators.tostring.api.GraphHeadToString;
import org.gradoop.flink.model.impl.operators.tostring.api.VertexToString;
import org.gradoop.flink.model.impl.operators.tostring.functions.AdjacencyMatrix;
import org.gradoop.flink.model.impl.operators.tostring.functions.ConcatGraphHeadStrings;
import org.gradoop.flink.model.impl.operators.tostring.functions.IncomingAdjacencyList;
import org.gradoop.flink.model.impl.operators.tostring.functions.MultiEdgeStringCombiner;
import org.gradoop.flink.model.impl.operators.tostring.functions.OutgoingAdjacencyList;
import org.gradoop.flink.model.impl.operators.tostring.functions.SourceStringUpdater;
import org.gradoop.flink.model.impl.operators.tostring.functions.SwitchSourceTargetIds;
import org.gradoop.flink.model.impl.operators.tostring.functions.TargetStringUpdater;
import org.gradoop.flink.model.impl.operators.tostring.functions.UndirectedAdjacencyList;
import org.gradoop.flink.model.impl.operators.tostring.tuples.GraphHeadString;

public class CanonicalAdjacencyMatrixBuilder<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements UnaryBaseGraphCollectionToValueOperator<GC, DataSet<String>> {
    private final GraphHeadToString<G> graphHeadToString;
    private final VertexToString<V> vertexToString;
    private final EdgeToString<E> egeLabelingFunction;
    private final boolean directed;

    public CanonicalAdjacencyMatrixBuilder(GraphHeadToString<G> graphHeadToString, VertexToString<V> vertexToString, EdgeToString<E> edgeLabelingFunction, boolean directed) {
        this.graphHeadToString = graphHeadToString;
        this.vertexToString = vertexToString;
        this.egeLabelingFunction = edgeLabelingFunction;
        this.directed = directed;
    }

    @Override
    public DataSet<String> execute(GC collection) {
        UnionOperator graphHeadLabels = this.getGraphHeadStrings(collection);
        graphHeadLabels = graphHeadLabels.union((DataSet)collection.getConfig().getExecutionEnvironment().fromElements((Object[])new GraphHeadString[]{new GraphHeadString(GradoopId.get(), "")}));
        return graphHeadLabels.reduceGroup((GroupReduceFunction)new ConcatGraphHeadStrings());
    }

    public DataSet<GraphHeadString> getGraphHeadStrings(GC collection) {
        MapOperator graphHeadLabels = collection.getGraphHeads().map(this.graphHeadToString);
        FlatMapOperator vertexLabels = collection.getVertices().flatMap(this.vertexToString);
        FlatMapOperator edgeLabels = collection.getEdges().flatMap(this.egeLabelingFunction);
        if (this.directed) {
            edgeLabels = edgeLabels.groupBy(new int[]{0, 1, 2}).reduceGroup((GroupReduceFunction)new MultiEdgeStringCombiner());
            edgeLabels = edgeLabels.join((DataSet)vertexLabels).where(new int[]{0, 1}).equalTo(new int[]{0, 1}).with((JoinFunction)new SourceStringUpdater()).join((DataSet)vertexLabels).where(new int[]{0, 2}).equalTo(new int[]{0, 1}).with((JoinFunction)new TargetStringUpdater());
            GroupReduceOperator outgoingAdjacencyListLabels = edgeLabels.groupBy(new int[]{0, 1}).reduceGroup((GroupReduceFunction)new OutgoingAdjacencyList());
            GroupReduceOperator incomingAdjacencyListLabels = edgeLabels.groupBy(new int[]{0, 2}).reduceGroup((GroupReduceFunction)new IncomingAdjacencyList());
            vertexLabels = vertexLabels.leftOuterJoin((DataSet)outgoingAdjacencyListLabels).where(new int[]{0, 1}).equalTo(new int[]{0, 1}).with(new LabelCombiner()).leftOuterJoin((DataSet)incomingAdjacencyListLabels).where(new int[]{0, 1}).equalTo(new int[]{0, 1}).with(new LabelCombiner());
        } else {
            edgeLabels = edgeLabels.union((DataSet)edgeLabels.map((MapFunction)new SwitchSourceTargetIds())).groupBy(new int[]{0, 1, 2}).reduceGroup((GroupReduceFunction)new MultiEdgeStringCombiner());
            edgeLabels = edgeLabels.join((DataSet)vertexLabels).where(new int[]{0, 2}).equalTo(new int[]{0, 1}).with((JoinFunction)new TargetStringUpdater());
            GroupReduceOperator adjacencyListLabels = edgeLabels.groupBy(new int[]{0, 1}).reduceGroup((GroupReduceFunction)new UndirectedAdjacencyList());
            vertexLabels = vertexLabels.leftOuterJoin((DataSet)adjacencyListLabels).where(new int[]{0, 1}).equalTo(new int[]{0, 1}).with(new LabelCombiner());
        }
        GroupReduceOperator adjacencyMatrixLabels = vertexLabels.groupBy(new int[]{0}).reduceGroup((GroupReduceFunction)new AdjacencyMatrix());
        graphHeadLabels = graphHeadLabels.leftOuterJoin((DataSet)adjacencyMatrixLabels).where(new int[]{0}).equalTo(new int[]{0}).with(new LabelCombiner());
        return graphHeadLabels;
    }
}

