/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.tostring.functions;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.tostring.tuples.GraphHeadString;
import org.gradoop.flink.model.impl.operators.tostring.tuples.VertexString;

public class AdjacencyMatrix
implements GroupReduceFunction<VertexString, GraphHeadString> {
    public void reduce(Iterable<VertexString> vertexLabels, Collector<GraphHeadString> collector) throws Exception {
        boolean first = true;
        GradoopId graphId = null;
        ArrayList<String> matrixRows = new ArrayList<String>();
        for (VertexString vertexString : vertexLabels) {
            if (first) {
                graphId = vertexString.getGraphId();
                first = false;
            }
            matrixRows.add("\n " + vertexString.getLabel());
        }
        Collections.sort(matrixRows);
        collector.collect((Object)new GraphHeadString(graphId, StringUtils.join(matrixRows, (String)"")));
    }
}

