/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.tostring.functions;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.tostring.tuples.EdgeString;
import org.gradoop.flink.model.impl.operators.tostring.tuples.VertexString;

public class IncomingAdjacencyList
implements GroupReduceFunction<EdgeString, VertexString> {
    public void reduce(Iterable<EdgeString> outgoingEdgeLabels, Collector<VertexString> collector) throws Exception {
        boolean first = true;
        GradoopId vertexId = null;
        GradoopId graphId = null;
        ArrayList<String> adjacencyListEntries = new ArrayList<String>();
        for (EdgeString edgeString : outgoingEdgeLabels) {
            if (first) {
                graphId = edgeString.getGraphId();
                vertexId = edgeString.getTargetId();
                first = false;
            }
            adjacencyListEntries.add("\n  <-" + edgeString.getEdgeLabel() + "-" + edgeString.getSourceLabel());
        }
        Collections.sort(adjacencyListEntries);
        collector.collect((Object)new VertexString(graphId, vertexId, StringUtils.join(adjacencyListEntries, (String)"")));
    }
}

