/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.tostring.functions;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.tostring.tuples.EdgeString;

public class MultiEdgeStringCombiner
implements GroupReduceFunction<EdgeString, EdgeString> {
    public void reduce(Iterable<EdgeString> iterable, Collector<EdgeString> collector) throws Exception {
        ArrayList<String> labels = new ArrayList<String>();
        boolean first = true;
        EdgeString combinedLabel = null;
        for (EdgeString edgeString : iterable) {
            if (first) {
                combinedLabel = edgeString;
                first = false;
            }
            labels.add(edgeString.getEdgeLabel());
        }
        Collections.sort(labels);
        if (combinedLabel != null) {
            combinedLabel.setEdgeLabel(StringUtils.join(labels, (String)"&"));
        }
        collector.collect(combinedLabel);
    }
}

