/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.transformation;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.functions.TransformationFunction;
import org.gradoop.flink.model.api.operators.ApplicableUnaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.model.impl.operators.transformation.Transformation;
import org.gradoop.flink.model.impl.operators.transformation.functions.TransformGraphTransaction;

public class ApplyTransformation<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
extends Transformation<G, V, E, LG, GC>
implements ApplicableUnaryBaseGraphToBaseGraphOperator<GC> {
    public ApplyTransformation(TransformationFunction<G> graphHeadModFunc, TransformationFunction<V> vertexModFunc, TransformationFunction<E> edgeModFunc) {
        super(graphHeadModFunc, vertexModFunc, edgeModFunc);
    }

    @Override
    public GC executeForGVELayout(GC collection) {
        Object modifiedGraph = this.executeInternal(collection.getGraphHeads(), collection.getVertices(), collection.getEdges(), collection.getGraphFactory());
        return collection.getFactory().fromDataSets(modifiedGraph.getGraphHead(), modifiedGraph.getVertices(), modifiedGraph.getEdges());
    }

    @Override
    public GC executeForTxLayout(GC collection) {
        if (collection instanceof GraphCollection) {
            DataSet<GraphTransaction> graphTransactions = collection.getGraphTransactions();
            MapOperator transformedGraphTransactions = graphTransactions.map(new TransformGraphTransaction(collection.getFactory().getGraphHeadFactory(), this.graphHeadTransFunc, collection.getFactory().getVertexFactory(), this.vertexTransFunc, collection.getFactory().getEdgeFactory(), this.edgeTransFunc));
            return collection.getFactory().fromTransactions((DataSet<GraphTransaction>)transformedGraphTransactions);
        }
        return this.executeForGVELayout(collection);
    }
}

