/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.transformation;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.epgm.BaseGraphFactory;
import org.gradoop.flink.model.api.functions.TransformationFunction;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphToBaseGraphOperator;
import org.gradoop.flink.model.impl.operators.transformation.functions.TransformEdge;
import org.gradoop.flink.model.impl.operators.transformation.functions.TransformGraphHead;
import org.gradoop.flink.model.impl.operators.transformation.functions.TransformVertex;

public class Transformation<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements UnaryBaseGraphToBaseGraphOperator<LG> {
    protected final TransformationFunction<G> graphHeadTransFunc;
    protected final TransformationFunction<V> vertexTransFunc;
    protected final TransformationFunction<E> edgeTransFunc;

    public Transformation(TransformationFunction<G> graphHeadTransFunc, TransformationFunction<V> vertexTransFunc, TransformationFunction<E> edgeTransFunc) {
        if (graphHeadTransFunc == null && vertexTransFunc == null && edgeTransFunc == null) {
            throw new IllegalArgumentException("Provide at least one transformation function.");
        }
        this.graphHeadTransFunc = graphHeadTransFunc;
        this.vertexTransFunc = vertexTransFunc;
        this.edgeTransFunc = edgeTransFunc;
    }

    @Override
    public LG execute(LG graph) {
        return this.executeInternal(graph.getGraphHead(), graph.getVertices(), graph.getEdges(), graph.getFactory());
    }

    protected LG executeInternal(DataSet<G> graphHeads, DataSet<V> vertices, DataSet<E> edges, BaseGraphFactory<G, V, E, LG, GC> factory) {
        SingleInputUdfOperator transformedGraphHeads = this.graphHeadTransFunc != null ? graphHeads.map(new TransformGraphHead<G>(this.graphHeadTransFunc, factory.getGraphHeadFactory())).returns(TypeExtractor.createTypeInfo((Class)factory.getGraphHeadFactory().getType())) : graphHeads;
        SingleInputUdfOperator transformedVertices = this.vertexTransFunc != null ? vertices.map(new TransformVertex<V>(this.vertexTransFunc, factory.getVertexFactory())).returns(TypeExtractor.createTypeInfo((Class)factory.getVertexFactory().getType())) : vertices;
        SingleInputUdfOperator transformedEdges = this.edgeTransFunc != null ? edges.map(new TransformEdge<E>(this.edgeTransFunc, factory.getEdgeFactory())).returns(TypeExtractor.createTypeInfo((Class)factory.getEdgeFactory().getType())) : edges;
        return factory.fromDataSets((DataSet<G>)transformedGraphHeads, (DataSet<V>)transformedVertices, (DataSet<E>)transformedEdges);
    }
}

