/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.transformation.functions;

import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.MapFunction;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.functions.TransformationFunction;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;

public class TransformGraphTransaction<G extends GraphHead, V extends Vertex, E extends Edge>
implements MapFunction<GraphTransaction, GraphTransaction> {
    private final GraphHeadFactory<G> graphHeadFactory;
    private final TransformationFunction<G> graphHeadTransFunc;
    private final VertexFactory<V> vertexFactory;
    private final TransformationFunction<V> vertexTransFunc;
    private final EdgeFactory<E> edgeFactory;
    private final TransformationFunction<E> edgeTransFunc;

    public TransformGraphTransaction(GraphHeadFactory<G> graphHeadFactory, TransformationFunction<G> graphHeadTransFunc, VertexFactory<V> vertexFactory, TransformationFunction<V> vertexTransFunc, EdgeFactory<E> edgeFactory, TransformationFunction<E> edgeTransFunc) {
        if (!(EPGMGraphHead.class.isAssignableFrom(graphHeadFactory.getType()) && EPGMVertex.class.isAssignableFrom(vertexFactory.getType()) && EPGMEdge.class.isAssignableFrom(edgeFactory.getType()))) {
            throw new UnsupportedOperationException("This map function only supports EPGM graphs");
        }
        this.graphHeadFactory = graphHeadFactory;
        this.graphHeadTransFunc = graphHeadTransFunc;
        this.vertexFactory = vertexFactory;
        this.vertexTransFunc = vertexTransFunc;
        this.edgeFactory = edgeFactory;
        this.edgeTransFunc = edgeTransFunc;
    }

    public GraphTransaction map(GraphTransaction transaction) throws Exception {
        if (this.graphHeadTransFunc != null) {
            transaction.setGraphHead((EPGMGraphHead)this.graphHeadTransFunc.apply(transaction.getGraphHead(), this.graphHeadFactory.initGraphHead(transaction.getGraphHead().getId(), "")));
        }
        if (this.vertexTransFunc != null) {
            transaction.setVertices(transaction.getVertices().stream().map((? super T vertex) -> (EPGMVertex)this.vertexTransFunc.apply(vertex, this.vertexFactory.initVertex(vertex.getId(), "", vertex.getGraphIds()))).collect(Collectors.toSet()));
        }
        if (this.edgeTransFunc != null) {
            transaction.setEdges(transaction.getEdges().stream().map((? super T edge) -> (EPGMEdge)this.edgeTransFunc.apply(edge, this.edgeFactory.initEdge(edge.getId(), "", edge.getSourceId(), edge.getTargetId(), edge.getGraphIds()))).collect(Collectors.toSet()));
        }
        return transaction;
    }
}

