/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.verify;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphCollectionToBaseGraphCollectionOperator;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.operators.verify.functions.RemoveDanglingGraphIds;

public class VerifyGraphsContainment<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements UnaryBaseGraphCollectionToBaseGraphCollectionOperator<GC> {
    @Override
    public GC execute(GC collection) {
        MapOperator idSet = collection.getGraphHeads().map(new Id());
        SingleInputUdfOperator verifiedVertices = collection.getVertices().map(new RemoveDanglingGraphIds()).withBroadcastSet((DataSet)idSet, "graphIds");
        SingleInputUdfOperator verifiedEdges = collection.getEdges().map(new RemoveDanglingGraphIds()).withBroadcastSet((DataSet)idSet, "graphIds");
        return collection.getFactory().fromDataSets(collection.getGraphHeads(), verifiedVertices, verifiedEdges);
    }
}

