/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.representation.transactional;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.functions.MapFunction;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.properties.Properties;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.representation.common.adjacencylist.AdjacencyListCell;
import org.gradoop.flink.representation.common.adjacencylist.AdjacencyListRow;
import org.gradoop.flink.representation.transactional.AdjacencyList;

public class RepresentationConverters {
    public static <ED, VD> AdjacencyList<GradoopId, String, ED, VD> getAdjacencyList(GraphTransaction transaction, MapFunction<EPGMEdge, ED> edgeDataFactory, MapFunction<EPGMVertex, VD> vertexDataFactory) throws Exception {
        Set<EPGMVertex> vertices = transaction.getVertices();
        Set<EPGMEdge> edges = transaction.getEdges();
        int vertexCount = vertices.size();
        HashMap labels = Maps.newHashMapWithExpectedSize((int)(1 + vertexCount + edges.size()));
        HashMap properties = Maps.newHashMap();
        HashMap outgoingRows = Maps.newHashMapWithExpectedSize((int)vertexCount);
        HashMap incomingRows = Maps.newHashMapWithExpectedSize((int)vertexCount);
        HashMap vertexIndex = Maps.newHashMapWithExpectedSize((int)vertexCount);
        for (EPGMVertex vertex : vertices) {
            RepresentationConverters.addLabelsAndProperties((Element)vertex, labels, properties);
            vertexIndex.put(vertex.getId(), vertex);
        }
        for (EPGMEdge edge : edges) {
            RepresentationConverters.addLabelsAndProperties((Element)edge, labels, properties);
            EPGMVertex source = (EPGMVertex)vertexIndex.get(edge.getSourceId());
            AdjacencyListRow outgoingRow = outgoingRows.computeIfAbsent(source.getId(), k -> new AdjacencyListRow());
            Object sourceData = vertexDataFactory.map((Object)source);
            EPGMVertex target = (EPGMVertex)vertexIndex.get(edge.getTargetId());
            AdjacencyListRow incomingRow = incomingRows.computeIfAbsent(target.getId(), k -> new AdjacencyListRow());
            Object targetData = vertexDataFactory.map((Object)target);
            Object edgeData = edgeDataFactory.map((Object)edge);
            outgoingRow.getCells().add(new AdjacencyListCell<Object, Object>(edgeData, targetData));
            incomingRow.getCells().add(new AdjacencyListCell<Object, Object>(edgeData, sourceData));
        }
        return new AdjacencyList(transaction.getGraphHead(), labels, properties, outgoingRows, incomingRows);
    }

    private static void addLabelsAndProperties(Element element, Map<GradoopId, String> labels, Map<GradoopId, Properties> properties) {
        labels.put(element.getId(), element.getLabel());
        Properties propertyList = element.getProperties();
        if (propertyList != null && !propertyList.isEmpty()) {
            properties.put(element.getId(), propertyList);
        }
    }

    public static GraphTransaction getGraphTransaction(AdjacencyList<GradoopId, String, GradoopId, GradoopId> adjacencyList) {
        EPGMGraphHead graphHead = adjacencyList.getGraphHead();
        GradoopIdSet graphIds = GradoopIdSet.fromExisting((GradoopId[])new GradoopId[]{graphHead.getId()});
        HashSet vertices = Sets.newHashSet();
        HashSet edges = Sets.newHashSet();
        for (Map.Entry<GradoopId, AdjacencyListRow<GradoopId, GradoopId>> entry : adjacencyList.getOutgoingRows().entrySet()) {
            GradoopId sourceId = entry.getKey();
            Properties properties = adjacencyList.getProperties(sourceId);
            String label = adjacencyList.getLabel(sourceId);
            vertices.add(new EPGMVertex(sourceId, label, properties, graphIds));
            for (AdjacencyListCell<GradoopId, GradoopId> cell : entry.getValue().getCells()) {
                GradoopId edgeId = cell.getEdgeData();
                label = adjacencyList.getLabel(edgeId);
                properties = adjacencyList.getProperties(edgeId);
                GradoopId targetId = cell.getVertexData();
                edges.add(new EPGMEdge(edgeId, label, sourceId, targetId, properties, graphIds));
            }
        }
        return new GraphTransaction(graphHead, vertices, edges);
    }
}

