/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.representation.transactional.traversalcode;

import java.io.Serializable;

public class Traversal<C extends Comparable<C>>
implements Serializable,
Comparable<Traversal<C>> {
    private static final char TIME_LABEL_SEPARATOR = ':';
    private static final char OUTGOING_CHAR = '>';
    private static final char INCOMING_CHAR = '<';
    private static final char EDGE_CHAR = '-';
    private final int fromTime;
    private final C fromValue;
    private final boolean outgoing;
    private final C edgeValue;
    private final int toTime;
    private final C toValue;

    public Traversal(int fromTime, C fromValue, boolean outgoing, C edgeValue, int toTime, C toValue) {
        this.fromTime = fromTime;
        this.fromValue = fromValue;
        this.outgoing = outgoing;
        this.edgeValue = edgeValue;
        this.toTime = toTime;
        this.toValue = toValue;
    }

    public boolean isBackwards() {
        return this.toTime <= this.fromTime;
    }

    public boolean isLoop() {
        return this.fromTime == this.toTime;
    }

    public int getFromTime() {
        return this.fromTime;
    }

    public C getFromValue() {
        return this.fromValue;
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }

    public C getEdgeValue() {
        return this.edgeValue;
    }

    public int getToTime() {
        return this.toTime;
    }

    public C getToValue() {
        return this.toValue;
    }

    public String toString() {
        return String.valueOf(this.fromTime) + ':' + this.fromValue + (this.outgoing ? (char)'>' : '<') + this.edgeValue + '-' + this.toTime + ':' + this.toValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Traversal that = (Traversal)o;
        if (this.fromTime != that.fromTime) {
            return false;
        }
        if (this.outgoing != that.outgoing) {
            return false;
        }
        if (this.toTime != that.toTime) {
            return false;
        }
        if (!this.fromValue.equals(that.fromValue)) {
            return false;
        }
        if (!this.edgeValue.equals(that.edgeValue)) {
            return false;
        }
        return this.toValue.equals(that.toValue);
    }

    public int hashCode() {
        int result = this.fromTime;
        result = 31 * result + this.fromValue.hashCode();
        result = 31 * result + (this.outgoing ? 1 : 0);
        result = 31 * result + this.edgeValue.hashCode();
        result = 31 * result + this.toTime;
        result = 31 * result + this.toValue.hashCode();
        return result;
    }

    @Override
    public int compareTo(Traversal<C> that) {
        int comparison;
        if (this.fromTime == that.fromTime && this.toTime == that.toTime) {
            comparison = this.fromValue.compareTo(that.fromValue);
            if (comparison == 0) {
                boolean thisIsOutgoing = this.isOutgoing();
                boolean thatIsOutgoing = that.isOutgoing();
                if (thisIsOutgoing && !thatIsOutgoing) {
                    comparison = -1;
                } else if (thatIsOutgoing && !thisIsOutgoing) {
                    comparison = 1;
                } else {
                    comparison = this.edgeValue.compareTo(that.edgeValue);
                    if (comparison == 0) {
                        comparison = this.toValue.compareTo(that.toValue);
                    }
                }
            }
        } else {
            boolean thisIsBacktrack = this.isBackwards();
            boolean thatIsBacktrack = that.isBackwards();
            comparison = thisIsBacktrack && !thatIsBacktrack ? -1 : (thatIsBacktrack && !thisIsBacktrack ? 1 : (thatIsBacktrack ? this.toTime - that.toTime : that.fromTime - this.fromTime));
        }
        return comparison;
    }

    public boolean isForwards() {
        return !this.isBackwards();
    }
}

