/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.representation.transactional.traversalcode;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gradoop.flink.representation.transactional.traversalcode.Traversal;

public class TraversalCode<C extends Comparable<C>>
implements Serializable,
Comparable<TraversalCode<C>> {
    private final List<Traversal<C>> traversals;

    public TraversalCode() {
        this.traversals = Lists.newArrayList();
    }

    public TraversalCode(Traversal<C> traversal) {
        this.traversals = Lists.newArrayListWithExpectedSize((int)1);
        this.traversals.add(traversal);
    }

    public TraversalCode(TraversalCode<C> parent) {
        this.traversals = Lists.newArrayList(parent.getTraversals());
    }

    public List<Traversal<C>> getTraversals() {
        return this.traversals;
    }

    public String toString() {
        return StringUtils.join(this.traversals, (char)',');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraversalCode code = (TraversalCode)o;
        return this.traversals.equals(code.traversals);
    }

    public int hashCode() {
        return this.traversals.hashCode();
    }

    @Override
    public int compareTo(TraversalCode<C> that) {
        int comparison;
        boolean thisIsRoot = this.getTraversals().isEmpty();
        boolean thatIsRoot = that.getTraversals().isEmpty();
        if (thisIsRoot && !thatIsRoot) {
            comparison = -1;
        } else if (thatIsRoot && !thisIsRoot) {
            comparison = 1;
        } else {
            comparison = 0;
            Iterator<Traversal<C>> thisIterator = this.getTraversals().iterator();
            Iterator<Traversal<C>> thatIterator = that.getTraversals().iterator();
            while (comparison == 0 && thisIterator.hasNext() && thatIterator.hasNext()) {
                comparison = thisIterator.next().compareTo(thatIterator.next());
            }
            if (comparison == 0) {
                if (thisIterator.hasNext()) {
                    comparison = 1;
                } else if (thatIterator.hasNext()) {
                    comparison = -1;
                }
            }
        }
        return comparison;
    }
}

