/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.FilterOperator;
import org.gradoop.common.model.api.entities.ElementFactoryProvider;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.util.AsciiGraphLoader;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.epgm.LogicalGraphFactory;
import org.gradoop.flink.model.impl.functions.epgm.RenameLabel;
import org.gradoop.flink.util.GradoopFlinkConfig;

public class FlinkAsciiGraphLoader {
    private final GradoopFlinkConfig config;
    private AsciiGraphLoader<EPGMGraphHead, EPGMVertex, EPGMEdge> loader;

    public FlinkAsciiGraphLoader(GradoopFlinkConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config must not be null.");
        }
        this.config = config;
    }

    public void initDatabaseFromString(String asciiGraphs) {
        if (asciiGraphs == null) {
            throw new IllegalArgumentException("AsciiGraph must not be null");
        }
        this.loader = AsciiGraphLoader.fromString((String)asciiGraphs, (ElementFactoryProvider)this.config.getLogicalGraphFactory());
    }

    public void initDatabaseFromStream(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("AsciiGraph must not be null");
        }
        this.loader = AsciiGraphLoader.fromStream((InputStream)stream, (ElementFactoryProvider)this.config.getLogicalGraphFactory());
    }

    public void appendToDatabaseFromString(String asciiGraph) {
        if (asciiGraph == null) {
            throw new IllegalArgumentException("AsciiGraph must not be null");
        }
        if (this.loader != null) {
            this.loader.appendFromString(asciiGraph);
        } else {
            this.initDatabaseFromString(asciiGraph);
        }
    }

    public void initDatabaseFromFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException("FileName must not be null.");
        }
        this.loader = AsciiGraphLoader.fromFile((String)fileName, (ElementFactoryProvider)this.config.getLogicalGraphFactory());
    }

    public LogicalGraph getLogicalGraph() {
        return this.getLogicalGraph(true);
    }

    public LogicalGraph getLogicalGraph(boolean withGraphContainment) {
        LogicalGraphFactory factory = this.config.getLogicalGraphFactory();
        if (withGraphContainment) {
            return (LogicalGraph)factory.fromCollections((Collection)this.getVertices(), (Collection)this.getEdges()).transformGraphHead(new RenameLabel("", "_DB"));
        }
        EPGMGraphHead graphHead = (EPGMGraphHead)factory.getGraphHeadFactory().createGraphHead("_DB");
        return factory.fromCollections(graphHead, this.getVertices(), this.getEdges());
    }

    public LogicalGraph getLogicalGraphByVariable(String variable) {
        EPGMGraphHead graphHead = this.getGraphHeadByVariable(variable);
        Collection<EPGMVertex> vertices = this.getVerticesByGraphVariables(variable);
        Collection<EPGMEdge> edges = this.getEdgesByGraphVariables(variable);
        return this.config.getLogicalGraphFactory().fromCollections(graphHead, vertices, edges);
    }

    public GraphCollection getGraphCollection() {
        ExecutionEnvironment env = this.config.getExecutionEnvironment();
        FilterOperator newVertices = env.fromCollection(this.getVertices()).filter((FilterFunction & Serializable)vertex -> vertex.getGraphCount() > 0);
        FilterOperator newEdges = env.fromCollection(this.getEdges()).filter((FilterFunction & Serializable)edge -> edge.getGraphCount() > 0);
        return this.config.getGraphCollectionFactory().fromDataSets((DataSet)env.fromCollection(this.getGraphHeads()), (DataSet)newVertices, (DataSet)newEdges);
    }

    public GraphCollection getGraphCollectionByVariables(String ... variables) {
        Collection<EPGMGraphHead> graphHeads = this.getGraphHeadsByVariables(variables);
        Collection<EPGMVertex> vertices = this.getVerticesByGraphVariables(variables);
        Collection<EPGMEdge> edges = this.getEdgesByGraphVariables(variables);
        return this.config.getGraphCollectionFactory().fromCollections((Collection)graphHeads, (Collection)vertices, (Collection)edges);
    }

    public Collection<EPGMGraphHead> getGraphHeads() {
        return this.loader.getGraphHeads();
    }

    public EPGMGraphHead getGraphHeadByVariable(String variable) {
        return (EPGMGraphHead)this.loader.getGraphHeadByVariable(variable);
    }

    public Collection<EPGMGraphHead> getGraphHeadsByVariables(String ... variables) {
        return this.loader.getGraphHeadsByVariables(variables);
    }

    public Collection<EPGMVertex> getVertices() {
        return this.loader.getVertices();
    }

    public Collection<EPGMVertex> getVerticesByGraphVariables(String ... variables) {
        return this.loader.getVerticesByGraphVariables(variables);
    }

    public EPGMVertex getVertexByVariable(String variable) {
        return (EPGMVertex)this.loader.getVertexByVariable(variable);
    }

    public Collection<EPGMEdge> getEdges() {
        return this.loader.getEdges();
    }

    public Collection<EPGMEdge> getEdgesByGraphVariables(String ... variables) {
        return this.loader.getEdgesByGraphVariables(variables);
    }

    public EPGMEdge getEdgeByVariable(String variable) {
        return (EPGMEdge)this.loader.getEdgeByVariable(variable);
    }
}

