/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.util;

import java.util.Objects;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.gradoop.common.config.GradoopConfig;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.api.epgm.BaseGraphCollectionFactory;
import org.gradoop.flink.model.api.epgm.BaseGraphFactory;
import org.gradoop.flink.model.api.layouts.GraphCollectionLayoutFactory;
import org.gradoop.flink.model.api.layouts.LogicalGraphLayoutFactory;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.GraphCollectionFactory;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.epgm.LogicalGraphFactory;
import org.gradoop.flink.model.impl.layouts.gve.GVECollectionLayoutFactory;
import org.gradoop.flink.model.impl.layouts.gve.GVEGraphLayoutFactory;

public class GradoopFlinkConfig
extends GradoopConfig<EPGMGraphHead, EPGMVertex, EPGMEdge> {
    private final ExecutionEnvironment executionEnvironment;
    private final BaseGraphFactory<EPGMGraphHead, EPGMVertex, EPGMEdge, LogicalGraph, GraphCollection> graphFactory;
    private final BaseGraphCollectionFactory<EPGMGraphHead, EPGMVertex, EPGMEdge, LogicalGraph, GraphCollection> graphCollectionFactory;

    protected GradoopFlinkConfig(ExecutionEnvironment executionEnvironment, LogicalGraphLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> logicalGraphLayoutFactory, GraphCollectionLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> graphCollectionLayoutFactory) {
        Objects.requireNonNull(executionEnvironment);
        Objects.requireNonNull(logicalGraphLayoutFactory);
        Objects.requireNonNull(graphCollectionLayoutFactory);
        this.executionEnvironment = executionEnvironment;
        this.graphFactory = new LogicalGraphFactory(this);
        this.graphFactory.setLayoutFactory(logicalGraphLayoutFactory);
        this.graphCollectionFactory = new GraphCollectionFactory(this);
        this.graphCollectionFactory.setLayoutFactory(graphCollectionLayoutFactory);
    }

    public static GradoopFlinkConfig createConfig(ExecutionEnvironment env) {
        return new GradoopFlinkConfig(env, new GVEGraphLayoutFactory(), new GVECollectionLayoutFactory());
    }

    public static GradoopFlinkConfig createConfig(ExecutionEnvironment env, LogicalGraphLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> logicalGraphLayoutFactory, GraphCollectionLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> graphCollectionLayoutFactory) {
        return new GradoopFlinkConfig(env, logicalGraphLayoutFactory, graphCollectionLayoutFactory);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public LogicalGraphFactory getLogicalGraphFactory() {
        return (LogicalGraphFactory)this.graphFactory;
    }

    public GraphCollectionFactory getGraphCollectionFactory() {
        return (GraphCollectionFactory)this.graphCollectionFactory;
    }

    public void setLogicalGraphLayoutFactory(LogicalGraphLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> factory) {
        Objects.requireNonNull(factory);
        factory.setGradoopFlinkConfig(this);
        this.graphFactory.setLayoutFactory(factory);
    }

    public void setGraphCollectionLayoutFactory(GraphCollectionLayoutFactory<EPGMGraphHead, EPGMVertex, EPGMEdge> factory) {
        Objects.requireNonNull(factory);
        factory.setGradoopFlinkConfig(this);
        this.graphCollectionFactory.setLayoutFactory(factory);
    }
}

