/*
 * Decompiled with CFR 0.152.
 */
package org.grails.async.transform.internal;

import grails.async.Promise;
import grails.async.Promises;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;
import org.grails.async.transform.internal.DelegateAsyncTransactionalMethodTransformer;
import org.grails.async.transform.internal.DelegateAsyncUtils;

@GroovyASTTransformation
public class DelegateAsyncTransformation
implements ASTTransformation {
    private static final ArgumentListExpression NO_ARGS = new ArgumentListExpression();
    private static final String VOID = "void";
    public static final ClassNode GROOVY_OBJECT_CLASS_NODE = new ClassNode(GroovyObjectSupport.class);
    public static final ClassNode OBJECT_CLASS_NODE = new ClassNode(Object.class);

    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode annotationNode = (AnnotationNode)nodes[0];
        if (parent instanceof ClassNode) {
            Expression value = annotationNode.getMember("value");
            if (value instanceof ClassExpression) {
                ClassNode classNode = (ClassNode)parent;
                ClassNode targetApi = value.getType().getPlainNodeReference();
                String fieldName = "$" + Introspector.decapitalize(targetApi.getNameWithoutPackage());
                FieldNode fieldNode = classNode.getField(fieldName);
                if (fieldNode == null) {
                    fieldNode = new FieldNode(fieldName, 2, targetApi, classNode, (Expression)new ConstructorCallExpression(targetApi, (Expression)NO_ARGS));
                    classNode.addField(fieldNode);
                }
                this.applyDelegateAsyncTransform(classNode, targetApi, fieldName);
            }
        } else if (parent instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)parent;
            ClassNode targetApi = fieldNode.getType().getPlainNodeReference();
            ClassNode classNode = fieldNode.getOwner();
            this.applyDelegateAsyncTransform(classNode, targetApi, fieldNode.getName());
        }
    }

    private void applyDelegateAsyncTransform(ClassNode classNode, ClassNode targetApi, String fieldName) {
        List methods = targetApi.getAllDeclaredMethods();
        ClassNode promisesClass = ClassHelper.make(Promises.class).getPlainNodeReference();
        MethodNode createPromiseMethodTargetWithDecorators = promisesClass.getDeclaredMethod("createPromise", new Parameter[]{new Parameter(new ClassNode(Closure.class), "c"), new Parameter(new ClassNode(List.class), "c")});
        DelegateAsyncTransactionalMethodTransformer delegateAsyncTransactionalMethodTransformer = this.lookupAsyncTransactionalMethodTransformer();
        for (MethodNode m : methods) {
            Parameter[] parameters;
            ClassNode returnType;
            MethodNode existingMethod;
            if (!DelegateAsyncTransformation.isCandidateMethod(m) || (existingMethod = classNode.getMethod(m.getName(), m.getParameters())) != null) continue;
            ClassNode promiseNode = ClassHelper.make(Promise.class).getPlainNodeReference();
            ClassNode originalReturnType = m.getReturnType();
            if (!originalReturnType.getNameWithoutPackage().equals(VOID) && !OBJECT_CLASS_NODE.equals((Object)(returnType = ClassHelper.isPrimitiveType((ClassNode)originalReturnType.redirect()) ? ClassHelper.getWrapper((ClassNode)originalReturnType.redirect()) : DelegateAsyncTransformation.alignReturnType(classNode, originalReturnType)))) {
                promiseNode.setGenericsTypes(new GenericsType[]{new GenericsType(returnType)});
            }
            BlockStatement methodBody = new BlockStatement();
            BlockStatement promiseBody = new BlockStatement();
            ClosureExpression closureExpression = new ClosureExpression(new Parameter[0], (Statement)promiseBody);
            VariableScope variableScope = new VariableScope();
            closureExpression.setVariableScope(variableScope);
            VariableExpression thisObject = new VariableExpression("this");
            ClassNode delegateAsyncUtilsClassNode = new ClassNode(DelegateAsyncUtils.class);
            MethodNode getPromiseDecoratorsMethodNode = (MethodNode)delegateAsyncUtilsClassNode.getDeclaredMethods("getPromiseDecorators").get(0);
            ListExpression promiseDecorators = new ListExpression();
            ArgumentListExpression getPromiseDecoratorsArguments = new ArgumentListExpression((Expression)thisObject, (Expression)promiseDecorators);
            delegateAsyncTransactionalMethodTransformer.transformTransactionalMethod(classNode, targetApi, m, promiseDecorators);
            MethodCallExpression getDecoratorsMethodCall = new MethodCallExpression((Expression)new ClassExpression(delegateAsyncUtilsClassNode), "getPromiseDecorators", (Expression)getPromiseDecoratorsArguments);
            getDecoratorsMethodCall.setMethodTarget(getPromiseDecoratorsMethodNode);
            MethodCallExpression createPromiseWithDecorators = new MethodCallExpression((Expression)new ClassExpression(promisesClass), "createPromise", (Expression)new ArgumentListExpression((Expression)closureExpression, (Expression)getDecoratorsMethodCall));
            if (createPromiseMethodTargetWithDecorators != null) {
                createPromiseWithDecorators.setMethodTarget(createPromiseMethodTargetWithDecorators);
            }
            methodBody.addStatement((Statement)new ExpressionStatement((Expression)createPromiseWithDecorators));
            ArgumentListExpression arguments = new ArgumentListExpression();
            for (Parameter p : parameters = DelegateAsyncTransformation.copyParameters(StaticTypeCheckingSupport.parameterizeArguments((ClassNode)classNode, (MethodNode)m))) {
                p.setClosureSharedVariable(true);
                variableScope.putReferencedLocalVariable((Variable)p);
                VariableExpression ve = new VariableExpression((Variable)p);
                ve.setClosureSharedVariable(true);
                arguments.addExpression((Expression)ve);
            }
            MethodCallExpression delegateMethodCall = new MethodCallExpression((Expression)new VariableExpression(fieldName), m.getName(), (Expression)arguments);
            promiseBody.addStatement((Statement)new ExpressionStatement((Expression)delegateMethodCall));
            MethodNode newMethodNode = new MethodNode(m.getName(), 1, promiseNode, parameters, null, (Statement)methodBody);
            classNode.addMethod(newMethodNode);
        }
    }

    private static ClassNode alignReturnType(ClassNode receiver, ClassNode originalReturnType) {
        ClassNode copiedReturnType = originalReturnType.getPlainNodeReference();
        ArrayList redirectTypes = new ArrayList();
        if (receiver.redirect().getGenericsTypes() != null) {
            Collections.addAll(redirectTypes, receiver.redirect().getGenericsTypes());
        }
        if (!redirectTypes.isEmpty()) {
            GenericsType[] redirectReceiverTypes = redirectTypes.toArray(new GenericsType[0]);
            GenericsType[] receiverParameterizedTypes = receiver.getGenericsTypes();
            if (receiverParameterizedTypes == null) {
                receiverParameterizedTypes = redirectReceiverTypes;
            }
            if (originalReturnType.isUsingGenerics()) {
                GenericsType[] alignmentTypes = originalReturnType.getGenericsTypes();
                GenericsType[] genericsTypes = GenericsUtils.alignGenericTypes((GenericsType[])redirectReceiverTypes, (GenericsType[])receiverParameterizedTypes, (GenericsType[])alignmentTypes);
                copiedReturnType.setGenericsTypes(genericsTypes);
            }
        }
        return copiedReturnType;
    }

    protected DelegateAsyncTransactionalMethodTransformer lookupAsyncTransactionalMethodTransformer() {
        try {
            Class<?> transformerClass = this.getClass().getClassLoader().loadClass("org.grails.async.transform.internal.DefaultDelegateAsyncTransactionalMethodTransformer");
            return (DelegateAsyncTransactionalMethodTransformer)transformerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            return new NoopDelegateAsyncTransactionalMethodTransformer();
        }
    }

    private static boolean isCandidateMethod(MethodNode declaredMethod) {
        String methodName = declaredMethod.getName();
        return !declaredMethod.isSynthetic() && !methodName.contains("$") && Modifier.isPublic(declaredMethod.getModifiers()) && !GROOVY_OBJECT_CLASS_NODE.hasMethod(declaredMethod.getName(), declaredMethod.getParameters());
    }

    private static Parameter[] copyParameters(Parameter[] parameterTypes) {
        Parameter[] newParameterTypes = new Parameter[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Parameter parameterType = parameterTypes[i];
            ClassNode parameterTypeCN = parameterType.getType();
            ClassNode newParameterTypeCN = parameterTypeCN.getPlainNodeReference();
            if (parameterTypeCN.isUsingGenerics() && !parameterTypeCN.isGenericsPlaceHolder()) {
                newParameterTypeCN.setGenericsTypes(parameterTypeCN.getGenericsTypes());
            }
            Parameter newParameter = new Parameter(newParameterTypeCN, parameterType.getName(), parameterType.getInitialExpression());
            newParameter.addAnnotations(parameterType.getAnnotations());
            newParameterTypes[i] = newParameter;
        }
        return newParameterTypes;
    }

    private static class NoopDelegateAsyncTransactionalMethodTransformer
    implements DelegateAsyncTransactionalMethodTransformer {
        private NoopDelegateAsyncTransactionalMethodTransformer() {
        }

        @Override
        public void transformTransactionalMethod(ClassNode classNode, ClassNode delegateClassNode, MethodNode methodNode, ListExpression promiseDecoratorLookupArguments) {
        }
    }
}

