/*
 * Decompiled with CFR 0.152.
 */
package grails.databinding;

import grails.databinding.BindInitializer;
import grails.databinding.BindUsing;
import grails.databinding.BindingFormat;
import grails.databinding.BindingHelper;
import grails.databinding.DataBinder;
import grails.databinding.DataBindingSource;
import grails.databinding.SimpleMapDataBindingSource;
import grails.databinding.StructuredBindingEditor;
import grails.databinding.converters.FormattedValueConverter;
import grails.databinding.converters.ValueConverter;
import grails.databinding.events.DataBindingListener;
import grails.databinding.initializers.ValueInitializer;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.Range;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.slurpersupport.GPathResult;
import java.beans.Transient;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.codehaus.groovy.reflection.CachedField;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.databinding.ClosureValueConverter;
import org.grails.databinding.ClosureValueInitializer;
import org.grails.databinding.IndexedPropertyReferenceDescriptor;
import org.grails.databinding.converters.ConversionService;
import org.grails.databinding.converters.FormattedDateValueConverter;
import org.grails.databinding.converters.StructuredCalendarBindingEditor;
import org.grails.databinding.converters.StructuredDateBindingEditor;
import org.grails.databinding.converters.StructuredSqlDateBindingEditor;
import org.grails.databinding.errors.SimpleBindingError;
import org.grails.databinding.xml.GPathResultMap;

public class SimpleDataBinder
implements DataBinder,
GroovyObject {
    protected Map<Class, StructuredBindingEditor> structuredEditors;
    private ConversionService conversionService;
    protected Map<Class, List<ValueConverter>> conversionHelpers;
    protected Map<Class, FormattedValueConverter> formattedValueConversionHelpers;
    protected static final List<Class> BASIC_TYPES;
    private static final Object INDEXED_PROPERTY_REGEX;
    private int autoGrowCollectionLimit;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public SimpleDataBinder() {
        MetaClass metaClass;
        int n;
        Map map;
        HashMap<Class, StructuredBindingEditor> hashMap = new HashMap<Class, StructuredBindingEditor>();
        this.structuredEditors = hashMap;
        this.conversionHelpers = map = DefaultGroovyMethods.withDefault((Map)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Closure)new _closure1(this, this));
        HashMap<Class, FormattedValueConverter> hashMap2 = new HashMap<Class, FormattedValueConverter>();
        this.formattedValueConversionHelpers = hashMap2;
        this.autoGrowCollectionLimit = n = 256;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.registerStructuredEditor(Date.class, new StructuredDateBindingEditor());
        this.registerStructuredEditor(java.sql.Date.class, new StructuredSqlDateBindingEditor());
        this.registerStructuredEditor(Calendar.class, new StructuredCalendarBindingEditor());
        this.registerFormattedValueConverter(new FormattedDateValueConverter());
    }

    public void registerStructuredEditor(Class clazz, StructuredBindingEditor editor) {
        StructuredBindingEditor structuredBindingEditor = editor;
        ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, this.structuredEditors, (String)"putAt", (Object[])new Object[]{clazz, structuredBindingEditor});
    }

    public void registerConverter(ValueConverter converter) {
        DefaultGroovyMethods.leftShift((List)((List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.conversionHelpers, converter.getTargetType()), List.class)), (Object)converter);
    }

    public void registerFormattedValueConverter(FormattedValueConverter converter) {
        FormattedValueConverter formattedValueConverter = converter;
        ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, this.formattedValueConversionHelpers, (String)"putAt", (Object[])new Object[]{converter.getTargetType(), formattedValueConverter});
    }

    @Override
    public void bind(Object obj, DataBindingSource source) {
        this.bind(obj, source, (String)null, (List)null, (List)null, (DataBindingListener)null);
    }

    @Override
    public void bind(Object obj, DataBindingSource source, DataBindingListener listener) {
        this.bind(obj, source, (String)null, (List)null, (List)null, listener);
    }

    public void bind(Object obj, DataBindingSource source, List whiteList) {
        this.bind(obj, source, (String)null, whiteList, (List)null, (DataBindingListener)null);
    }

    public void bind(Object obj, DataBindingSource source, List whiteList, List blackList) {
        this.bind(obj, source, (String)null, whiteList, blackList, (DataBindingListener)null);
    }

    @Override
    public void bind(Object obj, GPathResult gpath) {
        this.bind(obj, new SimpleMapDataBindingSource(new GPathResultMap(gpath)));
    }

    public void bind(Object obj, DataBindingSource source, String filter, List whiteList, List blackList) {
        this.bind(obj, source, filter, whiteList, blackList, (DataBindingListener)null);
    }

    public void bind(Object obj, DataBindingSource source, String filter, List whiteList, List blackList, DataBindingListener listener) {
        this.doBind(obj, source, filter, whiteList, blackList, listener, null);
    }

    protected void doBind(Object obj, DataBindingSource source, String filter, List whiteList, List blackList, DataBindingListener listener, Object errors) {
        Set<String> keys = source.getPropertyNames();
        Set<String> set = keys;
        Iterator<String> iterator = set != null ? set.iterator() : null;
        String key = null;
        Iterator<String> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                key = ShortTypeHandling.castToString((Object)iterator2.next());
                if (!(!DefaultTypeTransformation.booleanUnbox((Object)filter) || key.startsWith(StringGroovyMethods.plus((String)filter, (CharSequence)".")))) continue;
                String propName = key;
                if (DefaultTypeTransformation.booleanUnbox((Object)filter)) {
                    propName = StringGroovyMethods.getAt((String)key, (IntRange)new IntRange(true, 1 + StringGroovyMethods.size((CharSequence)filter), -1));
                }
                MetaProperty metaProperty = DefaultGroovyMethods.getMetaClass((Object)obj).getMetaProperty(propName);
                if (DefaultTypeTransformation.booleanUnbox((Object)metaProperty)) {
                    if (!this.isOkToBind(metaProperty, whiteList, blackList)) continue;
                    Object val = source.getAt(key);
                    try {
                        ValueConverter converter = this.getValueConverter(obj, metaProperty.getName());
                        if (DefaultTypeTransformation.booleanUnbox((Object)converter)) {
                            this.bindProperty(obj, source, metaProperty, converter.convert(source), listener, errors);
                            continue;
                        }
                        this.processProperty(obj, metaProperty, this.preprocessValue(val), source, listener, errors);
                    }
                    catch (Exception e) {
                        this.addBindingError(obj, propName, val, e, listener, errors);
                    }
                    continue;
                }
                IndexedPropertyReferenceDescriptor descriptor = this.getIndexedPropertyReferenceDescriptor(propName);
                if (DefaultTypeTransformation.booleanUnbox((Object)descriptor)) {
                    metaProperty = DefaultGroovyMethods.getMetaClass((Object)obj).getMetaProperty(descriptor.getPropertyName());
                    if (!(DefaultTypeTransformation.booleanUnbox((Object)metaProperty) && this.isOkToBind(metaProperty, whiteList, blackList))) continue;
                    Object val = source.getPropertyValue(key);
                    this.processIndexedProperty(obj, metaProperty, descriptor, val, source, listener, errors);
                    continue;
                }
                if (!(propName.startsWith("_") && propName.length() > 1)) continue;
                String restOfPropertyName = StringGroovyMethods.getAt((String)propName, (IntRange)new IntRange(true, 1, -1));
                if (!(!source.containsProperty(restOfPropertyName))) continue;
                metaProperty = DefaultGroovyMethods.getMetaClass((Object)obj).getMetaProperty(restOfPropertyName);
                if (!(DefaultTypeTransformation.booleanUnbox((Object)metaProperty) && this.isOkToBind(metaProperty, whiteList, blackList)) || !(ScriptBytecodeAdapter.compareEqual(Boolean.class, (Object)metaProperty.getType()) || ScriptBytecodeAdapter.compareEqual(Boolean.TYPE, (Object)metaProperty.getType()))) continue;
                this.bindProperty(obj, source, metaProperty, false, listener, errors);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isOkToBind(String propName, List whiteList, List blackList) {
        Reference propName2 = new Reference((Object)propName);
        if (!ScriptBytecodeAdapter.compareNotEqual((Object)"class", (Object)((String)propName2.get()))) return false;
        if (!ScriptBytecodeAdapter.compareNotEqual((Object)"classLoader", (Object)((String)propName2.get()))) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!ScriptBytecodeAdapter.compareNotEqual((Object)"protectionDomain", (Object)((String)propName2.get()))) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        if (!ScriptBytecodeAdapter.compareNotEqual((Object)"metaClass", (Object)((String)propName2.get()))) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        if (!ScriptBytecodeAdapter.compareNotEqual((Object)"metaPropertyValues", (Object)((String)propName2.get()))) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        if (!ScriptBytecodeAdapter.compareNotEqual((Object)"properties", (Object)((String)propName2.get()))) return false;
        boolean bl5 = true;
        if (!bl5) return false;
        List list = blackList;
        Boolean bl6 = list != null ? Boolean.valueOf(list.contains((String)propName2.get())) : null;
        if (bl6 == null ? false : bl6) return false;
        boolean bl7 = true;
        if (!bl7) return false;
        boolean bl8 = true;
        if (!bl8) return false;
        if (!DefaultTypeTransformation.booleanUnbox((Object)whiteList)) {
            return true;
        }
        boolean bl9 = false;
        if (bl9) return true;
        if (whiteList.contains((String)propName2.get())) {
            return true;
        }
        boolean bl10 = false;
        if (bl10) return true;
        public final class _isOkToBind_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference propName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _isOkToBind_closure2(Object _outerInstance, Object _thisObject, Reference propName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.propName = reference = propName;
            }

            public Boolean doCall(Object it) {
                Object object = it;
                String string = object != null ? DefaultGroovyMethods.toString((Object)object) : null;
                return string != null ? Boolean.valueOf(string.startsWith(StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)this.propName.get()), (CharSequence)"."))) : null;
            }

            @Generated
            public String getPropName() {
                return ShortTypeHandling.castToString((Object)this.propName.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _isOkToBind_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.find((Collection)whiteList, (Closure)new _isOkToBind_closure2(this, this, propName2)))) return false;
        return true;
    }

    protected boolean isOkToBind(MetaProperty property, List whitelist, List blacklist) {
        return this.isOkToBind(property.getName(), whitelist, blacklist) && property.getType() != null && !Modifier.isStatic(property.getModifiers()) && !(ClassLoader.class.isAssignableFrom(property.getType()) || ProtectionDomain.class.isAssignableFrom(property.getType()) || MetaProperty.class.isAssignableFrom(property.getType()) || CachedMethod.class.isAssignableFrom(property.getType()));
    }

    protected IndexedPropertyReferenceDescriptor getIndexedPropertyReferenceDescriptor(Object propName) {
        IndexedPropertyReferenceDescriptor descriptor = null;
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)propName, (Object)INDEXED_PROPERTY_REGEX), Matcher.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
            String indexedPropertyName = matcher.group(1);
            String index = matcher.group(2);
            if (StringGroovyMethods.size((CharSequence)index) > 2 && (index.startsWith("'") && index.endsWith("'") || index.startsWith("\"") && index.endsWith("\""))) {
                index = StringGroovyMethods.getAt((String)index, (IntRange)new IntRange(true, 1, -2));
            }
            IndexedPropertyReferenceDescriptor indexedPropertyReferenceDescriptor = new IndexedPropertyReferenceDescriptor();
            String string = indexedPropertyName;
            indexedPropertyReferenceDescriptor.setPropertyName(string);
            String string2 = index;
            indexedPropertyReferenceDescriptor.setIndex(string2);
            descriptor = indexedPropertyReferenceDescriptor;
        }
        return descriptor;
    }

    protected Object processProperty(Object obj, MetaProperty metaProperty, Object val, DataBindingSource source, DataBindingListener listener, Object errors) {
        String propName = metaProperty.getName();
        Class propertyType = metaProperty.getType();
        if (this.structuredEditors.containsKey(propertyType) && (ScriptBytecodeAdapter.compareEqual((Object)"struct", (Object)val) || ScriptBytecodeAdapter.compareEqual((Object)"date.struct", (Object)val))) {
            StructuredBindingEditor structuredEditor = (StructuredBindingEditor)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.structuredEditors, (Object)propertyType), StructuredBindingEditor.class);
            val = structuredEditor.getPropertyValue(obj, propName, source);
        }
        return this.bindProperty(obj, source, metaProperty, val, listener, errors);
    }

    protected SimpleMapDataBindingSource splitIndexedStruct(IndexedPropertyReferenceDescriptor indexedPropertyReferenceDescriptor, DataBindingSource source) {
        String propName = indexedPropertyReferenceDescriptor.getPropertyName();
        HashMap<String, Object> structValues = new HashMap<String, Object>();
        String prefix = indexedPropertyReferenceDescriptor.toString();
        Set<String> set = source.getPropertyNames();
        Iterator<String> iterator = set != null ? set.iterator() : null;
        String propertyName = null;
        Iterator<String> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                propertyName = ShortTypeHandling.castToString((Object)iterator2.next());
                if (!propertyName.startsWith(prefix)) continue;
                String deIndexedPropertyName = propName;
                Object[] parts = propertyName.split("_");
                if (parts.length > 1) {
                    deIndexedPropertyName = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)deIndexedPropertyName, (CharSequence)"_"), (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])parts, (int)1), CharSequence.class)));
                }
                structValues.put(deIndexedPropertyName, source.getPropertyValue(propertyName));
            }
        }
        return new SimpleMapDataBindingSource(structValues);
    }

    protected Object processIndexedProperty(Object obj, MetaProperty metaProperty, IndexedPropertyReferenceDescriptor indexedPropertyReferenceDescriptor, Object val, DataBindingSource source, DataBindingListener listener, Object errors) {
        String propName = indexedPropertyReferenceDescriptor.getPropertyName();
        Class propertyType = metaProperty.getType();
        Class<?> genericType = this.getReferencedTypeForCollection(propName, obj);
        if (this.structuredEditors.containsKey(genericType) && (ScriptBytecodeAdapter.compareEqual((Object)"struct", (Object)val) || ScriptBytecodeAdapter.compareEqual((Object)"date.struct", (Object)val))) {
            StructuredBindingEditor structuredEditor = (StructuredBindingEditor)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.structuredEditors, genericType), StructuredBindingEditor.class);
            val = structuredEditor.getPropertyValue(obj, propName, this.splitIndexedStruct(indexedPropertyReferenceDescriptor, source));
        }
        if (propertyType.isArray()) {
            int index = Integer.parseInt(indexedPropertyReferenceDescriptor.getIndex());
            Object array = this.initializeArray(obj, propName, propertyType.getComponentType(), index);
            if (array != null) {
                return this.addElementToArrayAt(array, index, val);
            }
            return null;
        }
        if (Collection.class.isAssignableFrom(propertyType)) {
            int index = Integer.parseInt(indexedPropertyReferenceDescriptor.getIndex());
            Collection collectionInstance = this.initializeCollection(obj, propName, propertyType);
            Object indexedInstance = null;
            if (!Set.class.isAssignableFrom(propertyType)) {
                indexedInstance = DefaultGroovyMethods.getAt((Iterable)collectionInstance, (int)index);
            }
            if (indexedInstance == null) {
                if (genericType != null) {
                    Object object = val;
                    if (genericType.isAssignableFrom(object != null ? object.getClass() : null)) {
                        return this.addElementToCollectionAt(obj, propName, collectionInstance, index, val);
                    }
                    if (this.isBasicType(genericType)) {
                        return this.addElementToCollectionAt(obj, propName, collectionInstance, index, this.convert(genericType, val));
                    }
                    if (val instanceof Map) {
                        indexedInstance = DefaultGroovyMethods.newInstance(genericType);
                        this.bind(indexedInstance, (DataBindingSource)new SimpleMapDataBindingSource((Map)ScriptBytecodeAdapter.castToType((Object)val, Map.class)), listener);
                        return this.addElementToCollectionAt(obj, propName, collectionInstance, index, indexedInstance);
                    }
                    if (val instanceof DataBindingSource) {
                        indexedInstance = DefaultGroovyMethods.newInstance(genericType);
                        this.bind(indexedInstance, (DataBindingSource)ScriptBytecodeAdapter.castToType((Object)val, DataBindingSource.class), listener);
                        return this.addElementToCollectionAt(obj, propName, collectionInstance, index, indexedInstance);
                    }
                    if (genericType.isEnum() && val instanceof CharSequence) {
                        Object enumValue = this.convertStringToEnum(genericType, ((CharSequence)val).toString());
                        return this.addElementToCollectionAt(obj, propName, collectionInstance, index, enumValue);
                    }
                    return this.addElementToCollectionAt(obj, propName, collectionInstance, index, this.convert(genericType, val));
                }
                return this.addElementToCollectionAt(obj, propName, collectionInstance, index, val);
            }
            if (val instanceof Map) {
                this.bind(indexedInstance, (DataBindingSource)new SimpleMapDataBindingSource((Map)ScriptBytecodeAdapter.castToType((Object)val, Map.class)), listener);
                return null;
            }
            if (val instanceof DataBindingSource) {
                this.bind(indexedInstance, (DataBindingSource)ScriptBytecodeAdapter.castToType((Object)val, DataBindingSource.class), listener);
                return null;
            }
            if (val == null && indexedInstance != null) {
                return this.addElementToCollectionAt(obj, propName, collectionInstance, index, null);
            }
            return null;
        }
        if (Map.class.isAssignableFrom(propertyType)) {
            Map mapInstance = this.initializeMap(obj, propName);
            if (mapInstance.size() < this.autoGrowCollectionLimit || mapInstance.containsKey(indexedPropertyReferenceDescriptor.getIndex())) {
                Class<?> referencedType = this.getReferencedTypeForCollection(propName, obj);
                if (referencedType != null) {
                    if (val instanceof Map) {
                        Object object = DefaultGroovyMethods.newInstance(referencedType, (Object[])new Object[]{val});
                        ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)mapInstance, (String)"putAt", (Object[])new Object[]{indexedPropertyReferenceDescriptor.getIndex(), object});
                        return object;
                    }
                    Object object = this.convert(referencedType, val);
                    ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)mapInstance, (String)"putAt", (Object[])new Object[]{indexedPropertyReferenceDescriptor.getIndex(), object});
                    return object;
                }
                Object object = val;
                ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)mapInstance, (String)"putAt", (Object[])new Object[]{indexedPropertyReferenceDescriptor.getIndex(), object});
                return object;
            }
            return null;
        }
        return null;
    }

    protected Object initializeArray(Object obj, String propertyName, Class arrayType, int index) {
        CallSite[] callSiteArray = SimpleDataBinder.$getCallSiteArray();
        Object[] array = (Object[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(obj, (Object)propertyName), Object[].class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)array, null) && index < this.autoGrowCollectionLimit) {
                array = (Object[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(Array.class, (Object)arrayType, callSiteArray[2].call((Object)index, (Object)1)), Object[].class);
                Object[] objectArray = array;
                callSiteArray[3].call(obj, (Object)propertyName, (Object)objectArray);
            } else if (ScriptBytecodeAdapter.compareNotEqual((Object)array, null) && ScriptBytecodeAdapter.compareLessThanEqual((Object)callSiteArray[4].callGetProperty((Object)array), (Object)index) && index < this.autoGrowCollectionLimit) {
                Object newArray = callSiteArray[5].call(Array.class, (Object)arrayType, callSiteArray[6].call((Object)index, (Object)1));
                callSiteArray[7].call(System.class, ArrayUtil.createArray((Object)array, (Object)0, (Object)newArray, (Object)0, (Object)callSiteArray[8].callGetProperty((Object)array)));
                array = (Object[])ScriptBytecodeAdapter.castToType((Object)newArray, Object[].class);
                Object object = newArray;
                callSiteArray[9].call(obj, (Object)propertyName, object);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)array, null) && index < this.autoGrowCollectionLimit) {
            array = (Object[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call(Array.class, (Object)arrayType, (Object)(index + 1)), Object[].class);
            Object[] objectArray = array;
            callSiteArray[11].call(obj, (Object)propertyName, (Object)objectArray);
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)array, null) && ScriptBytecodeAdapter.compareLessThanEqual((Object)callSiteArray[12].callGetProperty((Object)array), (Object)index) && index < this.autoGrowCollectionLimit) {
            Object newArray = callSiteArray[13].call(Array.class, (Object)arrayType, (Object)(index + 1));
            callSiteArray[14].call(System.class, ArrayUtil.createArray((Object)array, (Object)0, (Object)newArray, (Object)0, (Object)callSiteArray[15].callGetProperty((Object)array)));
            array = (Object[])ScriptBytecodeAdapter.castToType((Object)newArray, Object[].class);
            Object object = newArray;
            callSiteArray[16].call(obj, (Object)propertyName, object);
        }
        return array;
    }

    protected boolean isBasicType(Class c) {
        return BASIC_TYPES.contains(c) || c.isPrimitive();
    }

    protected Class<?> getReferencedTypeForCollectionInClass(String propertyName, Class clazz) {
        Class referencedType = null;
        Field field = this.getField(clazz, propertyName);
        if (field != null) {
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)ScriptBytecodeAdapter.castToType((Object)genericType, ParameterizedType.class);
                Class rawType = ShortTypeHandling.castToClass((Object)pt.getRawType());
                referencedType = Map.class.isAssignableFrom(rawType) ? ShortTypeHandling.castToClass((Object)BytecodeInterface8.objectArrayGet((Object[])pt.getActualTypeArguments(), (int)1)) : ShortTypeHandling.castToClass((Object)BytecodeInterface8.objectArrayGet((Object[])pt.getActualTypeArguments(), (int)0));
            }
        }
        return referencedType;
    }

    protected Class<?> getReferencedTypeForCollection(String propertyName, Object obj) {
        return this.getReferencedTypeForCollectionInClass(propertyName, obj.getClass());
    }

    protected boolean isOkToAddElementAt(Collection collection, int index) {
        boolean isOk = false;
        isOk = collection instanceof Set ? ((Set)ScriptBytecodeAdapter.castToType((Object)collection, Set.class)).size() < this.autoGrowCollectionLimit : index < this.autoGrowCollectionLimit || index < collection.size();
        return isOk;
    }

    protected Object addElementToCollectionAt(Object obj, String propertyName, Collection collection, Object index, Object val) {
        CallSite[] callSiteArray = SimpleDataBinder.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callCurrent((GroovyObject)this, (Object)collection, index))) {
            if (collection instanceof Set) {
                return callSiteArray[18].call((Object)collection, val);
            }
            Object object = val;
            callSiteArray[19].call((Object)collection, index, object);
            return object;
        }
        return null;
    }

    protected Object addElementToArrayAt(Object array, Object index, Object val) {
        CallSite[] callSiteArray = SimpleDataBinder.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[20].callGetProperty(array), (Object)index)) {
            Object object = callSiteArray[21].callCurrent((GroovyObject)this, callSiteArray[22].callGetProperty(callSiteArray[23].callGetProperty(array)), val);
            callSiteArray[24].call(array, index, object);
            return object;
        }
        return null;
    }

    protected Map initializeMap(Object obj, String propertyName) {
        if (DefaultGroovyMethods.getAt((Object)obj, (String)propertyName) == null) {
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)obj, (String)"putAt", (Object[])new Object[]{propertyName, map});
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Object)obj, (String)propertyName), Map.class);
    }

    protected Collection initializeCollection(Object obj, String propertyName, Class type, boolean reuseExistingCollectionIfExists) {
        Object val = null;
        if (reuseExistingCollectionIfExists) {
            val = DefaultGroovyMethods.getAt((Object)obj, (String)propertyName);
        }
        if (val == null) {
            val = this.getDefaultCollectionInstanceForType(type);
            Object object = val;
            ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)obj, (String)"putAt", (Object[])new Object[]{propertyName, object});
        }
        return (Collection)ScriptBytecodeAdapter.castToType((Object)val, Collection.class);
    }

    protected Object getDefaultCollectionInstanceForType(Class type) {
        Collection val = null;
        if (List.class.isAssignableFrom(type)) {
            val = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        } else if (SortedSet.class.isAssignableFrom(type)) {
            val = new TreeSet();
        } else if (LinkedHashSet.class.isAssignableFrom(type)) {
            val = new LinkedHashSet();
        } else if (Collection.class.isAssignableFrom(type)) {
            val = new HashSet();
        }
        return val;
    }

    /*
     * WARNING - void declaration
     */
    protected ValueConverter getFormattedConverter(Field field, String formattingValue) {
        void var2_2;
        Reference field2 = new Reference((Object)field);
        Reference formattingValue2 = new Reference((Object)var2_2);
        ValueConverter converter = null;
        Reference formattedConverter = new Reference((Object)((FormattedValueConverter)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.formattedValueConversionHelpers, ((Field)field2.get()).getType()), FormattedValueConverter.class)));
        if (DefaultTypeTransformation.booleanUnbox((Object)((FormattedValueConverter)formattedConverter.get()))) {
            public final class _getFormattedConverter_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference field;
                private /* synthetic */ Reference formattedConverter;
                private /* synthetic */ Reference formattingValue;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getFormattedConverter_closure3(Object _outerInstance, Object _thisObject, Reference field, Reference formattedConverter, Reference formattingValue) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.field = reference3 = field;
                    this.formattedConverter = reference2 = formattedConverter;
                    this.formattingValue = reference = formattingValue;
                }

                public Object doCall(SimpleMapDataBindingSource source) {
                    Object value = InvokerHelper.invokeMethodSafe((Object)((SimpleDataBinder)this.getThisObject()), (String)"preprocessValue", (Object)new Object[]{source.getPropertyValue(((Field)ScriptBytecodeAdapter.castToType((Object)this.field.get(), Field.class)).getName())});
                    Object convertedValue = null;
                    if (value != null) {
                        convertedValue = ((FormattedValueConverter)ScriptBytecodeAdapter.castToType((Object)this.formattedConverter.get(), FormattedValueConverter.class)).convert(value, ShortTypeHandling.castToString((Object)this.formattingValue.get()));
                    }
                    return convertedValue;
                }

                @Generated
                public Object call(SimpleMapDataBindingSource source) {
                    return this.doCall(source);
                }

                @Generated
                public Field getField() {
                    return (Field)ScriptBytecodeAdapter.castToType((Object)this.field.get(), Field.class);
                }

                @Generated
                public FormattedValueConverter getFormattedConverter() {
                    return (FormattedValueConverter)ScriptBytecodeAdapter.castToType((Object)this.formattedConverter.get(), FormattedValueConverter.class);
                }

                @Generated
                public String getFormattingValue() {
                    return ShortTypeHandling.castToString((Object)this.formattingValue.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getFormattedConverter_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            converter = (ValueConverter)ScriptBytecodeAdapter.asType((Object)((Object)new _getFormattedConverter_closure3(this, this, field2, formattedConverter, formattingValue2)), ValueConverter.class);
        }
        return converter;
    }

    protected Field getField(Class clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
            Class superClass = clazz.getSuperclass();
            if (ScriptBytecodeAdapter.compareNotEqual(superClass, Object.class)) {
                field = this.getField(superClass, fieldName);
            }
        }
        return field;
    }

    protected ValueConverter getValueConverterForField(Object obj, String propName) {
        ValueConverter converter = null;
        Field field = this.getField(obj.getClass(), propName);
        if (field != null) {
            Annotation annotation = field.getAnnotation(BindUsing.class);
            if (DefaultTypeTransformation.booleanUnbox((Object)annotation)) {
                Class valueClass = this.getValueOfBindUsing(annotation);
                if (Closure.class.isAssignableFrom(valueClass)) {
                    Closure closure = (Closure)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.newInstance((Class)valueClass, (Object[])new Object[]{null, null}), Closure.class);
                    ClosureValueConverter closureValueConverter = new ClosureValueConverter();
                    Closure closure2 = closure.curry(obj);
                    closureValueConverter.setConverterClosure(closure2);
                    Class<?> clazz = field.getType();
                    closureValueConverter.setTargetType(clazz);
                    converter = closureValueConverter;
                }
            } else {
                annotation = field.getAnnotation(BindingFormat.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)annotation)) {
                    converter = this.getFormattedConverter(field, this.getFormatString(annotation));
                }
            }
        }
        ValueConverter valueConverter = converter;
        try {
            return valueConverter;
        }
        catch (Exception ignored) {
            ValueConverter valueConverter2 = (ValueConverter)ScriptBytecodeAdapter.castToType(null, ValueConverter.class);
            return valueConverter2;
        }
    }

    protected Class getValueOfBindUsing(Annotation annotation) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Annotation annotation2 = annotation;
            valueRecorder.record((Object)annotation2, 8);
            boolean bl = annotation2 instanceof BindUsing;
            valueRecorder.record((Object)bl, 19);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert annotation instanceof BindUsing", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (annotation instanceof BindUsing) {
            return ((BindUsing)ScriptBytecodeAdapter.castToType((Object)annotation, BindUsing.class)).value();
        }
        return ShortTypeHandling.castToClass(null);
    }

    protected String getFormatString(Annotation annotation) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Annotation annotation2 = annotation;
            valueRecorder.record((Object)annotation2, 8);
            boolean bl = annotation2 instanceof BindingFormat;
            valueRecorder.record((Object)bl, 19);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert annotation instanceof BindingFormat", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (annotation instanceof BindingFormat) {
            return ((BindingFormat)ScriptBytecodeAdapter.castToType((Object)annotation, BindingFormat.class)).value();
        }
        return ShortTypeHandling.castToString(null);
    }

    /*
     * WARNING - void declaration
     */
    protected ValueConverter getValueConverterForClass(Object obj, String propName) {
        void var2_2;
        Reference obj2 = new Reference(obj);
        Reference propName2 = new Reference((Object)var2_2);
        ClosureValueConverter converter = null;
        Class<?> objClass = obj2.get().getClass();
        BindUsing annotation = (BindUsing)ScriptBytecodeAdapter.castToType((Object)objClass.getAnnotation(BindUsing.class), BindUsing.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)annotation)) {
            Class valueClass = this.getValueOfBindUsing(annotation);
            if (BindingHelper.class.isAssignableFrom(valueClass)) {
                Reference dataConverter = new Reference((Object)((BindingHelper)ScriptBytecodeAdapter.castToType(valueClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), BindingHelper.class)));
                ClosureValueConverter closureValueConverter = new ClosureValueConverter();
                public final class _getValueConverterForClass_closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference dataConverter;
                    private /* synthetic */ Reference obj;
                    private /* synthetic */ Reference propName;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _getValueConverterForClass_closure4(Object _outerInstance, Object _thisObject, Reference dataConverter, Reference obj, Reference propName) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.dataConverter = reference3 = dataConverter;
                        this.obj = reference2 = obj;
                        this.propName = reference = propName;
                    }

                    public Object doCall(DataBindingSource it) {
                        return ((BindingHelper)ScriptBytecodeAdapter.castToType((Object)this.dataConverter.get(), BindingHelper.class)).getPropertyValue(this.obj.get(), ShortTypeHandling.castToString((Object)this.propName.get()), it);
                    }

                    @Generated
                    public Object call(DataBindingSource it) {
                        return this.doCall(it);
                    }

                    @Generated
                    public BindingHelper getDataConverter() {
                        return (BindingHelper)ScriptBytecodeAdapter.castToType((Object)this.dataConverter.get(), BindingHelper.class);
                    }

                    @Generated
                    public Object getObj() {
                        return this.obj.get();
                    }

                    @Generated
                    public String getPropName() {
                        return ShortTypeHandling.castToString((Object)this.propName.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getValueConverterForClass_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                _getValueConverterForClass_closure4 _getValueConverterForClass_closure42 = new _getValueConverterForClass_closure4(this, this, dataConverter, obj2, propName2);
                closureValueConverter.setConverterClosure(_getValueConverterForClass_closure42);
                converter = closureValueConverter;
            }
        }
        return converter;
    }

    protected ValueConverter getValueConverter(Object obj, String propName) {
        ValueConverter converter = this.getValueConverterForField(obj, propName);
        if (!DefaultTypeTransformation.booleanUnbox((Object)converter)) {
            converter = this.getValueConverterForClass(obj, propName);
        }
        return converter;
    }

    protected Object convertStringToEnum(Class<? extends Enum> enumClass, String value) {
        CallSite[] callSiteArray = SimpleDataBinder.$getCallSiteArray();
        Object object = callSiteArray[25].call(enumClass, (Object)value);
        try {
            return object;
        }
        catch (IllegalArgumentException iae) {
            Object var6_6 = null;
            return var6_6;
        }
    }

    protected Object preprocessValue(Object propertyValue) {
        return propertyValue;
    }

    protected Object setPropertyValue(Object obj, DataBindingSource source, MetaProperty metaProperty, Object propertyValue, DataBindingListener listener) {
        boolean convertCollectionElements = false;
        if (propertyValue instanceof Collection) {
            Reference referencedType = new Reference(this.getReferencedTypeForCollection(metaProperty.getName(), obj));
            if ((Class)referencedType.get() != null) {
                public final class _setPropertyValue_closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference referencedType;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _setPropertyValue_closure5(Object _outerInstance, Object _thisObject, Reference referencedType) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.referencedType = reference = referencedType;
                    }

                    public Boolean doCall(Object it) {
                        return it != null && !ShortTypeHandling.castToClass((Object)this.referencedType.get()).isAssignableFrom(it.getClass());
                    }

                    @Generated
                    public Class getReferencedType() {
                        return ShortTypeHandling.castToClass((Object)this.referencedType.get());
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Boolean doCall() {
                        CallSite[] callSiteArray = _setPropertyValue_closure5.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _setPropertyValue_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_setPropertyValue_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _setPropertyValue_closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Object nonAssignableValue = DefaultGroovyMethods.find((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)propertyValue, Collection.class)), (Closure)new _setPropertyValue_closure5(this, this, referencedType));
                if (nonAssignableValue != null) {
                    convertCollectionElements = true;
                }
            }
        }
        return this.setPropertyValue(obj, source, metaProperty, propertyValue, listener, convertCollectionElements);
    }

    protected Object setPropertyValue(Object obj, DataBindingSource source, MetaProperty metaProperty, Object propertyValue, DataBindingListener listener, boolean convertCollectionElements) {
        String propName = metaProperty.getName();
        Class<?> propertyType = null;
        MetaMethod propertyGetter = null;
        if (metaProperty instanceof MetaBeanProperty) {
            CachedField cachedField;
            MetaBeanProperty mbp = (MetaBeanProperty)ScriptBytecodeAdapter.castToType((Object)metaProperty, MetaBeanProperty.class);
            MetaMethod metaMethod = mbp.getGetter();
            Class clazz = metaMethod != null ? metaMethod.getReturnType() : null;
            propertyType = DefaultTypeTransformation.booleanUnbox((Object)clazz) ? clazz : ((cachedField = mbp.getField()) != null ? cachedField.getType() : null);
            if (DefaultTypeTransformation.booleanUnbox((Object)propertyType) && (propertyType.isInterface() || Modifier.isAbstract(propertyType.getModifiers()))) {
                CachedField cachedField2 = mbp.getField();
                propertyType = cachedField2 != null ? cachedField2.getType() : null;
            }
            propertyGetter = mbp.getGetter();
        }
        if (propertyType == null || ScriptBytecodeAdapter.compareEqual(propertyType, Object.class)) {
            propertyType = metaProperty.getType();
            if (propertyType == null || ScriptBytecodeAdapter.compareEqual((Object)propertyType, Object.class)) {
                Field field = this.getField(obj.getClass(), propName);
                Class<?> clazz = field != null ? field.getType() : null;
                propertyType = DefaultTypeTransformation.booleanUnbox(clazz) ? clazz : Object.class;
            }
        }
        if (propertyValue == null || ScriptBytecodeAdapter.compareEqual((Object)propertyType, Object.class) || propertyType.isAssignableFrom(propertyValue.getClass())) {
            if (convertCollectionElements && !(propertyValue instanceof Range) && propertyValue instanceof Collection && Collection.class.isAssignableFrom(propertyType) && DefaultTypeTransformation.booleanUnbox(propertyGetter)) {
                this.addElementsToCollection(obj, propName, (Collection)ScriptBytecodeAdapter.castToType((Object)propertyValue, Collection.class), true);
                return null;
            }
            Object object = propertyValue;
            ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)obj, (String)"putAt", (Object[])new Object[]{propName, object});
            return object;
        }
        if (propertyValue instanceof List && Set.class.isAssignableFrom(propertyType) && !SortedSet.class.isAssignableFrom(propertyType)) {
            this.addElementsToCollection(obj, propName, (Collection)ScriptBytecodeAdapter.castToType((Object)propertyValue, Collection.class), true);
            return null;
        }
        if (propertyValue instanceof Map) {
            if (Collection.class.isAssignableFrom(propertyType) && ((Map)propertyValue).size() == 1 && DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)propertyValue, Map.class)), (Object)DefaultGroovyMethods.getAt(((Map)propertyValue).keySet(), (int)0)) instanceof List) {
                Object key = DefaultGroovyMethods.getAt(((Map)propertyValue).keySet(), (int)0);
                List list = (List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)propertyValue, Map.class)), (Object)key), List.class);
                this.addElementsToCollection(obj, propName, list);
                return null;
            }
            if (DefaultGroovyMethods.getAt((Object)obj, (String)propName) == null) {
                this.initializeProperty(obj, propName, propertyType, source);
            }
            this.bind(DefaultGroovyMethods.getAt((Object)obj, (String)propName), (DataBindingSource)new SimpleMapDataBindingSource((Map)ScriptBytecodeAdapter.castToType((Object)propertyValue, Map.class)), listener);
            return null;
        }
        if (propertyValue instanceof DataBindingSource) {
            if (Collection.class.isAssignableFrom(propertyType) && ((DataBindingSource)propertyValue).size() == 1 && DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)propertyValue, Map.class)), (Object)DefaultGroovyMethods.getAt(((DataBindingSource)propertyValue).getPropertyNames(), (int)0)) instanceof List) {
                String key = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(((DataBindingSource)propertyValue).getPropertyNames(), (int)0));
                List list = (List)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)propertyValue, Map.class)), (Object)key), List.class);
                this.addElementsToCollection(obj, propName, list);
                return null;
            }
            if (DefaultGroovyMethods.getAt((Object)obj, (String)propName) == null) {
                this.initializeProperty(obj, propName, propertyType, source);
            }
            this.bind(DefaultGroovyMethods.getAt((Object)obj, (String)propName), (DataBindingSource)ScriptBytecodeAdapter.castToType((Object)propertyValue, DataBindingSource.class), listener);
            return null;
        }
        if (Collection.class.isAssignableFrom(propertyType) && propertyValue instanceof String) {
            return this.addElementToCollection(obj, propName, propertyType, propertyValue, true);
        }
        if (Collection.class.isAssignableFrom(propertyType) && propertyValue instanceof Number) {
            return this.addElementToCollection(obj, propName, propertyType, propertyValue, true);
        }
        if (Collection.class.isAssignableFrom(propertyType) && propertyValue.getClass().isArray()) {
            this.addElementsToCollection(obj, propName, (Collection)ScriptBytecodeAdapter.asType((Object)propertyValue, Collection.class), true);
            return null;
        }
        Object object = this.convert(propertyType, propertyValue);
        ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)obj, (String)"putAt", (Object[])new Object[]{propName, object});
        return object;
    }

    protected Object addElementToCollection(Object obj, String propName, Class propertyType, Object propertyValue, boolean clearCollection) {
        boolean isSet = false;
        Collection coll = this.initializeCollection(obj, propName, propertyType);
        if (coll != null) {
            if (clearCollection) {
                coll.clear();
            }
            Class<?> referencedType = this.getReferencedTypeForCollection(propName, obj);
            if (referencedType != null) {
                if (propertyValue == null || referencedType.isAssignableFrom(propertyValue.getClass())) {
                    DefaultGroovyMethods.leftShift((Collection)coll, (Object)propertyValue);
                    isSet = true;
                } else {
                    DefaultGroovyMethods.leftShift((Collection)coll, (Object)this.convert(referencedType, propertyValue));
                    isSet = true;
                }
            }
        }
        return isSet;
    }

    protected Object bindProperty(Object obj, DataBindingSource source, MetaProperty metaProperty, Object propertyValue, DataBindingListener listener, Object errors) {
        Object v0;
        DataBindingListener dataBindingListener;
        String propName = metaProperty.getName();
        if (listener == null || ScriptBytecodeAdapter.compareNotEqual((Object)listener.beforeBinding(obj, propName, propertyValue, errors), (Object)false)) {
            try {
                this.setPropertyValue(obj, source, metaProperty, propertyValue, listener);
            }
            catch (Exception e) {
                this.addBindingError(obj, propName, propertyValue, e, listener, errors);
            }
        } else if (listener != null && propertyValue instanceof Map && DefaultGroovyMethods.getAt((Object)obj, (String)propName) != null) {
            this.bind(DefaultGroovyMethods.getAt((Object)obj, (String)propName), new SimpleMapDataBindingSource((Map)ScriptBytecodeAdapter.castToType((Object)propertyValue, Map.class)));
        }
        if ((dataBindingListener = listener) != null) {
            dataBindingListener.afterBinding(obj, propName, errors);
            v0 = null;
        } else {
            v0 = null;
        }
        return v0;
    }

    protected Object addBindingError(Object obj, String propName, Object propertyValue, Exception e, DataBindingListener listener, Object errors) {
        if (DefaultTypeTransformation.booleanUnbox((Object)listener)) {
            Throwable throwable = e.getCause();
            SimpleBindingError error = new SimpleBindingError(obj, propName, propertyValue, DefaultTypeTransformation.booleanUnbox((Object)throwable) ? throwable : e);
            listener.bindingError(error, errors);
            return null;
        }
        return null;
    }

    private void addElementsToCollection(Object obj, String collectionPropertyName, Collection collection, boolean removeExistingElements) {
        Collection collection2;
        Class propertyType = DefaultGroovyMethods.getMetaClass((Object)obj).getMetaProperty(collectionPropertyName).getType();
        Class<?> referencedType = this.getReferencedTypeForCollection(collectionPropertyName, obj);
        Collection coll = this.initializeCollection(obj, collectionPropertyName, propertyType, !removeExistingElements);
        if (ScriptBytecodeAdapter.compareEqual((Object)removeExistingElements, (Object)true)) {
            coll.clear();
        }
        Iterator iterator = (collection2 = collection) != null ? collection2.iterator() : null;
        Object element = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                element = iterator2.next();
                if (element == null || referencedType == null || referencedType.isAssignableFrom(element.getClass())) {
                    DefaultGroovyMethods.leftShift((Collection)coll, (Object)element);
                    continue;
                }
                DefaultGroovyMethods.leftShift((Collection)coll, (Object)this.convert(referencedType, element));
            }
        }
        Collection collection3 = coll;
        ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)obj, (String)"putAt", (Object[])new Object[]{collectionPropertyName, collection3});
    }

    protected Object initializeProperty(Object obj, String propName, Class propertyType, DataBindingSource source) {
        ValueInitializer initializer = this.getPropertyInitializer(obj, propName);
        if (DefaultTypeTransformation.booleanUnbox((Object)initializer)) {
            Object object = initializer.initialize();
            ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)obj, (String)"putAt", (Object[])new Object[]{propName, object});
            return object;
        }
        Object object = DefaultGroovyMethods.newInstance((Class)propertyType);
        ScriptBytecodeAdapter.invokeMethodN(SimpleDataBinder.class, (Object)obj, (String)"putAt", (Object[])new Object[]{propName, object});
        return object;
    }

    protected ValueInitializer getPropertyInitializer(Object obj, String propName) {
        ValueInitializer initializer = this.getValueInitializerForField(obj, propName);
        return initializer;
    }

    protected ValueInitializer getValueInitializerForField(Object obj, String propName) {
        ClosureValueInitializer initializer = null;
        try {
            Field field = this.getField(obj.getClass(), propName);
            if (field != null) {
                BindInitializer annotation = (BindInitializer)ScriptBytecodeAdapter.castToType((Object)field.getAnnotation(BindInitializer.class), BindInitializer.class);
                if (DefaultTypeTransformation.booleanUnbox((Object)annotation)) {
                    Class valueClass = this.getValueOfBindInitializer(annotation);
                    if (Closure.class.isAssignableFrom(valueClass)) {
                        Closure closure = (Closure)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.newInstance((Class)valueClass, (Object[])new Object[]{null, null}), Closure.class);
                        ClosureValueInitializer closureValueInitializer = new ClosureValueInitializer();
                        Closure closure2 = closure.curry(obj);
                        closureValueInitializer.setInitializerClosure(closure2);
                        Class<?> clazz = field.getType();
                        closureValueInitializer.setTargetType(clazz);
                        initializer = closureValueInitializer;
                    }
                }
            }
        }
        catch (Exception e) {
        }
        return initializer;
    }

    protected Class getValueOfBindInitializer(Annotation annotation) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Annotation annotation2 = annotation;
            valueRecorder.record((Object)annotation2, 8);
            boolean bl = annotation2 instanceof BindInitializer;
            valueRecorder.record((Object)bl, 19);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert annotation instanceof BindInitializer", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Class<?> value = null;
        if (annotation instanceof BindInitializer) {
            value = ((BindInitializer)ScriptBytecodeAdapter.castToType((Object)annotation, BindInitializer.class)).value();
        }
        return value;
    }

    protected Object convert(Class typeToConvertTo, Object value) {
        ConversionService conversionService;
        Object object;
        if (value == null || typeToConvertTo.isAssignableFrom((object = value) != null ? object.getClass() : null)) {
            return value;
        }
        if (this.conversionHelpers.containsKey(typeToConvertTo)) {
            ValueConverter converter = this.getConverter(typeToConvertTo, value);
            if (DefaultTypeTransformation.booleanUnbox((Object)converter)) {
                return converter.convert(value);
            }
        }
        Boolean bl = (conversionService = this.conversionService) != null ? Boolean.valueOf(conversionService.canConvert(value.getClass(), typeToConvertTo)) : null;
        if (bl == null ? false : bl) {
            return this.conversionService.convert(value, typeToConvertTo);
        }
        if (Collection.class.isAssignableFrom(typeToConvertTo) && value instanceof String[]) {
            if (ScriptBytecodeAdapter.compareEqual(Set.class, (Object)typeToConvertTo)) {
                return (Set)ScriptBytecodeAdapter.asType((Object)value, Set.class);
            }
            if (ScriptBytecodeAdapter.compareEqual(List.class, (Object)typeToConvertTo)) {
                return (List)ScriptBytecodeAdapter.asType((Object)value, List.class);
            }
        } else {
            if (typeToConvertTo.isPrimitive() || typeToConvertTo.isArray()) {
                return value;
            }
            if (value instanceof Map) {
                Object obj = DefaultGroovyMethods.newInstance((Class)typeToConvertTo);
                this.bind(obj, new SimpleMapDataBindingSource((Map)ScriptBytecodeAdapter.castToType((Object)value, Map.class)));
                return obj;
            }
            if (Enum.class.isAssignableFrom(typeToConvertTo) && value instanceof String) {
                return this.convertStringToEnum(typeToConvertTo, ShortTypeHandling.castToString((Object)value));
            }
        }
        return DefaultGroovyMethods.newInstance((Class)typeToConvertTo, (Object[])new Object[]{value});
    }

    protected ValueConverter getConverter(Class typeToConvertTo, Object value) {
        Reference value2 = new Reference(value);
        List converters = (List)ScriptBytecodeAdapter.castToType(this.conversionHelpers.get(typeToConvertTo), List.class);
        List list = converters;
        public final class _getConverter_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference value;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getConverter_closure6(Object _outerInstance, Object _thisObject, Reference value) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.value = reference = value;
            }

            public Boolean doCall(ValueConverter c) {
                return c.canConvert(this.value.get());
            }

            @Generated
            public Boolean call(ValueConverter c) {
                return this.doCall(c);
            }

            @Generated
            public Object getValue() {
                return this.value.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getConverter_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return (ValueConverter)ScriptBytecodeAdapter.castToType(list != null ? DefaultGroovyMethods.find((Collection)list, (Closure)new _getConverter_closure6(this, this, value2)) : null, ValueConverter.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SimpleDataBinder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    protected Collection initializeCollection(Object obj, String propertyName, Class type) {
        CallSite[] callSiteArray = SimpleDataBinder.$getCallSiteArray();
        return this.initializeCollection(obj, propertyName, type, true);
    }

    @Generated
    private void addElementsToCollection(Object obj, String collectionPropertyName, Collection collection) {
        CallSite[] callSiteArray = SimpleDataBinder.$getCallSiteArray();
        this.addElementsToCollection(obj, collectionPropertyName, collection, false);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        List list;
        String string = "(.*)\\[\\s*([^\\s]*)\\s*\\]\\s*$";
        INDEXED_PROPERTY_REGEX = string;
        BASIC_TYPES = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{String.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class});
    }

    @Generated
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Generated
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Generated
    public static Object getINDEXED_PROPERTY_REGEX() {
        return INDEXED_PROPERTY_REGEX;
    }

    @Generated
    public int getAutoGrowCollectionLimit() {
        return this.autoGrowCollectionLimit;
    }

    @Generated
    public void setAutoGrowCollectionLimit(int n) {
        this.autoGrowCollectionLimit = n;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getAt";
        stringArray[1] = "newInstance";
        stringArray[2] = "plus";
        stringArray[3] = "putAt";
        stringArray[4] = "length";
        stringArray[5] = "newInstance";
        stringArray[6] = "plus";
        stringArray[7] = "arraycopy";
        stringArray[8] = "length";
        stringArray[9] = "putAt";
        stringArray[10] = "newInstance";
        stringArray[11] = "putAt";
        stringArray[12] = "length";
        stringArray[13] = "newInstance";
        stringArray[14] = "arraycopy";
        stringArray[15] = "length";
        stringArray[16] = "putAt";
        stringArray[17] = "isOkToAddElementAt";
        stringArray[18] = "add";
        stringArray[19] = "putAt";
        stringArray[20] = "length";
        stringArray[21] = "convert";
        stringArray[22] = "componentType";
        stringArray[23] = "class";
        stringArray[24] = "putAt";
        stringArray[25] = "valueOf";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[26];
        SimpleDataBinder.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(SimpleDataBinder.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = SimpleDataBinder.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public List doCall(Object c) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

