/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.plugins.codecs;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.codehaus.groovy.grails.support.encoding.CharSequences;
import org.codehaus.groovy.grails.support.encoding.CodecIdentifier;
import org.codehaus.groovy.grails.support.encoding.EncodedAppender;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodesToWriter;
import org.codehaus.groovy.grails.support.encoding.EncodesToWriterAdapter;
import org.codehaus.groovy.grails.support.encoding.EncodingState;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoder;

public abstract class AbstractCharReplacementEncoder
implements Encoder,
StreamingEncoder,
EncodesToWriter {
    protected CodecIdentifier codecIdentifier;

    public AbstractCharReplacementEncoder(CodecIdentifier codecIdentifier) {
        this.codecIdentifier = codecIdentifier;
    }

    protected abstract String escapeCharacter(char var1, char var2);

    @Override
    public Object encode(Object o) {
        return this.doCharReplacementEncoding(o);
    }

    protected final Object doCharReplacementEncoding(Object o) {
        if (o == null) {
            return null;
        }
        CharSequence str = null;
        if (o instanceof CharSequence) {
            str = (CharSequence)o;
        } else {
            if (o instanceof Character) {
                String escaped = this.escapeCharacter(((Character)o).charValue(), '\u0000');
                if (escaped != null) {
                    return escaped;
                }
                return o;
            }
            str = this.convertToString(o);
        }
        return this.escapeCharSequence(str);
    }

    protected String convertToString(Object o) {
        return String.valueOf(o);
    }

    protected Object escapeCharSequence(CharSequence str) {
        int i;
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sb = null;
        int n = str.length();
        int startPos = -1;
        char prevChar = '\u0000';
        for (i = 0; i < n; ++i) {
            String escaped;
            char ch = str.charAt(i);
            if (startPos == -1) {
                startPos = i;
            }
            if ((escaped = this.escapeCharacter(ch, prevChar)) != null) {
                if (sb == null) {
                    sb = new StringBuilder(str.length() * 110 / 100);
                }
                if (i - startPos > 0) {
                    sb.append(str, startPos, i);
                }
                if (escaped.length() > 0) {
                    sb.append(escaped);
                }
                startPos = -1;
            }
            prevChar = ch;
        }
        if (sb != null) {
            if (startPos > -1 && i - startPos > 0) {
                sb.append(str, startPos, i);
            }
            return sb.toString();
        }
        return str;
    }

    @Override
    public void encodeToWriter(CharSequence str, int off, int len, Writer writer, EncodingState encodingState) throws IOException {
        int i;
        if (str == null || len <= 0) {
            return;
        }
        int n = Math.min(str.length(), off + len);
        int startPos = -1;
        char prevChar = '\u0000';
        for (i = off; i < n; ++i) {
            String escaped;
            char ch = str.charAt(i);
            if (startPos == -1) {
                startPos = i;
            }
            if ((escaped = this.escapeCharacter(ch, prevChar)) != null) {
                if (i - startPos > 0) {
                    CharSequences.writeCharSequence(writer, str, startPos, i);
                }
                if (escaped.length() > 0) {
                    writer.write(escaped);
                }
                startPos = -1;
            }
            prevChar = ch;
        }
        if (startPos > -1 && i - startPos > 0) {
            CharSequences.writeCharSequence(writer, str, startPos, i);
        }
    }

    @Override
    public void encodeToWriter(char[] buf, int off, int len, Writer writer, EncodingState encodingState) throws IOException {
        int i;
        if (buf == null || len <= 0) {
            return;
        }
        int n = Math.min(buf.length, off + len);
        int startPos = -1;
        char prevChar = '\u0000';
        for (i = off; i < n; ++i) {
            String escaped;
            char ch = buf[i];
            if (startPos == -1) {
                startPos = i;
            }
            if ((escaped = this.escapeCharacter(ch, prevChar)) != null) {
                if (i - startPos > 0) {
                    writer.write(buf, startPos, i - startPos);
                }
                if (escaped.length() > 0) {
                    writer.write(escaped);
                }
                startPos = -1;
            }
            prevChar = ch;
        }
        if (startPos > -1 && i - startPos > 0) {
            writer.write(buf, startPos, i - startPos);
        }
    }

    @Override
    public EncodesToWriter createChainingEncodesToWriter(List<StreamingEncoder> encoders, boolean applyAdditionalFirst) {
        return EncodesToWriterAdapter.createChainingEncodesToWriter(this, encoders, applyAdditionalFirst);
    }

    @Override
    public void encodeToStream(Encoder thisInstance, CharSequence str, int off, int len, EncodedAppender appender, EncodingState encodingState) throws IOException {
        int i;
        if (str == null || len <= 0) {
            return;
        }
        int n = Math.min(str.length(), off + len);
        int startPos = -1;
        char prevChar = '\u0000';
        for (i = off; i < n; ++i) {
            String escaped;
            char ch = str.charAt(i);
            if (startPos == -1) {
                startPos = i;
            }
            if ((escaped = this.escapeCharacter(ch, prevChar)) != null) {
                if (i - startPos > 0) {
                    appender.appendEncoded(thisInstance, encodingState, str, startPos, i - startPos);
                }
                if (escaped.length() > 0) {
                    appender.appendEncoded(thisInstance, encodingState, escaped, 0, escaped.length());
                }
                startPos = -1;
            }
            prevChar = ch;
        }
        if (startPos > -1 && i - startPos > 0) {
            appender.appendEncoded(thisInstance, encodingState, str, startPos, i - startPos);
        }
    }

    @Override
    public void markEncoded(CharSequence string) {
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public boolean isApplyToSafelyEncoded() {
        return false;
    }

    @Override
    public CodecIdentifier getCodecIdentifier() {
        return this.codecIdentifier;
    }
}

