/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.support.encoding;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.grails.plugins.codecs.BasicCodecLookup;
import org.codehaus.groovy.grails.plugins.codecs.NoneEncoder;
import org.codehaus.groovy.grails.support.encoding.Encoder;
import org.codehaus.groovy.grails.support.encoding.EncodingState;
import org.codehaus.groovy.grails.support.encoding.EncodingStateImpl;
import org.codehaus.groovy.grails.support.encoding.EncodingStateRegistry;
import org.codehaus.groovy.grails.support.encoding.StreamingEncoder;

public final class DefaultEncodingStateRegistry
implements EncodingStateRegistry {
    private Map<Encoder, Set<Integer>> encodingTagIdentityHashCodes = new HashMap<Encoder, Set<Integer>>();
    public static final StreamingEncoder NONE_ENCODER = BasicCodecLookup.NONE_ENCODER;

    private Set<Integer> getIdentityHashCodesForEncoder(Encoder encoder) {
        Set<Integer> identityHashCodes = this.encodingTagIdentityHashCodes.get(encoder);
        if (identityHashCodes == null) {
            identityHashCodes = new HashSet<Integer>();
            this.encodingTagIdentityHashCodes.put(encoder, identityHashCodes);
        }
        return identityHashCodes;
    }

    @Override
    public EncodingState getEncodingStateFor(CharSequence string) {
        int identityHashCode = System.identityHashCode(string);
        Set<Encoder> result = null;
        for (Map.Entry<Encoder, Set<Integer>> entry : this.encodingTagIdentityHashCodes.entrySet()) {
            if (!entry.getValue().contains(identityHashCode)) continue;
            if (result == null) {
                result = Collections.singleton(entry.getKey());
                continue;
            }
            if (result.size() == 1) {
                result = new HashSet<Encoder>(result);
            }
            result.add(entry.getKey());
        }
        return result != null ? new EncodingStateImpl(result, null) : EncodingStateImpl.UNDEFINED_ENCODING_STATE;
    }

    @Override
    public boolean isEncodedWith(Encoder encoder, CharSequence string) {
        return this.getIdentityHashCodesForEncoder(encoder).contains(System.identityHashCode(string));
    }

    @Override
    public void registerEncodedWith(Encoder encoder, CharSequence escaped) {
        this.getIdentityHashCodesForEncoder(encoder).add(System.identityHashCode(escaped));
    }

    @Override
    public boolean shouldEncodeWith(Encoder encoderToApply, CharSequence string) {
        if (DefaultEncodingStateRegistry.isNoneEncoder(encoderToApply)) {
            return false;
        }
        EncodingState encodingState = this.getEncodingStateFor(string);
        return DefaultEncodingStateRegistry.shouldEncodeWith(encoderToApply, encodingState);
    }

    public static boolean shouldEncodeWith(Encoder encoderToApply, EncodingState currentEncodingState) {
        if (DefaultEncodingStateRegistry.isNoneEncoder(encoderToApply)) {
            return false;
        }
        if (currentEncodingState != null && currentEncodingState.getEncoders() != null) {
            for (Encoder encoder : currentEncodingState.getEncoders()) {
                if (!DefaultEncodingStateRegistry.isPreviousEncoderSafeOrEqual(encoderToApply, encoder)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNoneEncoder(Encoder encoderToApply) {
        return encoderToApply == null || encoderToApply == NONE_ENCODER || encoderToApply.getClass() == NoneEncoder.class;
    }

    public static boolean isPreviousEncoderSafeOrEqual(Encoder encoderToApply, Encoder previousEncoder) {
        return previousEncoder == encoderToApply || !encoderToApply.isApplyToSafelyEncoded() && previousEncoder.isSafe() && encoderToApply.isSafe() || previousEncoder.getCodecIdentifier().isEquivalent(encoderToApply.getCodecIdentifier());
    }
}

