/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.radeox.macro.BaseLocaleMacro;
import org.radeox.macro.Macro;
import org.radeox.macro.MacroRepository;
import org.radeox.macro.parameter.MacroParameter;
import org.radeox.util.i18n.ResourceManager;

public class MacroListMacro
extends BaseLocaleMacro {
    @Override
    public String getLocaleKey() {
        return "macro.macrolist";
    }

    @Override
    public void execute(Writer writer, MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        if (macroParameter.getLength() != 0) {
            throw new IllegalArgumentException("MacroListMacro: number of arguments does not match");
        }
        this.appendTo(writer, (String)this.initialContext.get("RenderContext.language_bundle_name"));
    }

    public Writer appendTo(Writer writer, String string) throws IOException {
        List list = MacroRepository.getInstance().getPlugins();
        Collections.sort(list);
        Iterator iterator = list.iterator();
        writer.write("<table class=\"wiki-table\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
        writer.write("<tr><th>");
        writer.write(ResourceManager.getString(string, this.getLocaleKey() + ".title.macro"));
        writer.write("</th>");
        writer.write("<th>");
        writer.write(ResourceManager.getString(string, this.getLocaleKey() + ".title.parameters"));
        writer.write("</th>");
        writer.write("<th>");
        writer.write(ResourceManager.getString(string, this.getLocaleKey() + ".title.description"));
        writer.write("</th></tr>\n");
        while (iterator.hasNext()) {
            writer.write("<tr>");
            Macro macro = (Macro)iterator.next();
            writer.write("<td>");
            writer.write(macro.getName());
            writer.write("</td><td>");
            String[] stringArray = macro.getParamDescription();
            if (stringArray.length == 0) {
                writer.write("<i>");
                writer.write(ResourceManager.getString(string, this.getLocaleKey() + ".noparams"));
                writer.write("</i>");
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i].trim();
                    if (string2.startsWith("???") && string2.endsWith("???")) {
                        writer.write("<div class=\"error\">");
                        writer.write(string2);
                        writer.write("</div>");
                    } else if (string2.startsWith("?")) {
                        writer.write(string2.substring(1));
                        writer.write(" <i>");
                        writer.write(ResourceManager.getString(string, this.getLocaleKey() + ".optional"));
                        writer.write("</i>");
                    } else {
                        writer.write(stringArray[i]);
                    }
                    writer.write("<br/>");
                }
            }
            writer.write("</td><td>");
            writer.write(macro.getDescription());
            writer.write("</td>\n");
        }
        writer.write("</table>");
        return writer;
    }
}

