/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.radeox.regex.Compiler;
import org.radeox.regex.MatchResult;
import org.radeox.regex.Matcher;
import org.radeox.regex.Pattern;
import org.radeox.regex.Substitution;

public class Encoder {
    private static final String DELIMITER = "&\"'<>[]";
    private static final Map ESCAPED_CHARS = new HashMap();

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (ESCAPED_CHARS.containsKey(string2)) {
                stringBuffer.append(ESCAPED_CHARS.get(string2));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Compiler compiler = Compiler.create();
        Pattern pattern = compiler.compile("&(#?[0-9a-fA-F]+);");
        Matcher matcher = Matcher.create(string, pattern);
        stringBuffer.append(matcher.substitute(new Substitution(){

            @Override
            public void handleMatch(StringBuffer stringBuffer, MatchResult matchResult) {
                stringBuffer.append(Encoder.toChar(matchResult.group(1)));
            }
        }));
        return stringBuffer.toString();
    }

    public static String toEntity(int n) {
        return "&#" + n + ";";
    }

    public static char toChar(String string) {
        return (char)Integer.decode(string.substring(1)).intValue();
    }

    static {
        ESCAPED_CHARS.put("&", Encoder.toEntity(38));
        ESCAPED_CHARS.put("\"", Encoder.toEntity(34));
        ESCAPED_CHARS.put("'", Encoder.toEntity(39));
        ESCAPED_CHARS.put(">", Encoder.toEntity(62));
        ESCAPED_CHARS.put("<", Encoder.toEntity(60));
        ESCAPED_CHARS.put("[", Encoder.toEntity(91));
        ESCAPED_CHARS.put("]", Encoder.toEntity(93));
    }
}

