/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import groovy.util.ConfigObject;
import java.util.Map;
import org.codehaus.groovy.grails.orm.hibernate.EventTriggeringInterceptor;
import org.codehaus.groovy.grails.orm.hibernate.HibernateSession;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.model.MappingContext;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDatastore
extends AbstractDatastore {
    private SessionFactory sessionFactory;
    private ConfigObject config;
    private EventTriggeringInterceptor eventTriggeringInterceptor;

    public HibernateDatastore(MappingContext mappingContext, SessionFactory sessionFactory, ApplicationContext applicationContext, ConfigObject config) {
        super(mappingContext);
        this.sessionFactory = sessionFactory;
        this.config = config;
        super.initializeConverters(mappingContext);
        this.setApplicationContext(applicationContext);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected Session createSession(Map<String, String> connectionDetails) {
        return new HibernateSession(this, this.sessionFactory);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext, (String)"ApplicationContext must be an instanceof ConfigurableApplicationContext");
        ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
        super.setApplicationContext(configurableContext);
        this.eventTriggeringInterceptor = new EventTriggeringInterceptor(this, this.config);
        configurableContext.addApplicationListener((ApplicationListener)this.eventTriggeringInterceptor);
    }

    protected boolean registerValidationListener() {
        return false;
    }

    public EventTriggeringInterceptor getEventTriggeringInterceptor() {
        return this.eventTriggeringInterceptor;
    }
}

