/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.TransactionManager;
import org.codehaus.groovy.grails.orm.hibernate.SessionFactoryHolder;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.hibernate.Cache;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.TypeHelper;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.Region;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.QueryPlanCache;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.InfrastructureProxy;
import org.springframework.orm.hibernate3.SpringSessionContext;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionFactoryProxy
extends GroovyObjectSupport
implements SessionFactory,
SessionFactoryImplementor,
ApplicationContextAware,
InitializingBean,
InfrastructureProxy {
    private static final long serialVersionUID = 1L;
    private String targetBean;
    private ApplicationContext applicationContext;
    private Class currentSessionContextClass = SpringSessionContext.class;

    public void setTargetBean(String targetBean) {
        this.targetBean = targetBean;
    }

    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return InvokerHelper.getProperty((Object)this.getCurrentSessionFactory(), (String)property);
        }
    }

    public void setCurrentSessionContextClass(Class currentSessionContextClass) {
        this.currentSessionContextClass = currentSessionContextClass;
    }

    public SessionFactory getCurrentSessionFactory() {
        SessionFactory sf = ((SessionFactoryHolder)this.applicationContext.getBean(this.targetBean, SessionFactoryHolder.class)).getSessionFactory();
        this.updateCurrentSessionContext(sf);
        return sf;
    }

    public SessionFactoryImplementor getCurrentSessionFactoryImplementor() {
        return (SessionFactoryImplementor)this.getCurrentSessionFactory();
    }

    public Session openSession() throws HibernateException {
        return this.getCurrentSessionFactory().openSession();
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        return this.getCurrentSessionFactory().openSession(interceptor);
    }

    public Session openSession(Connection connection) {
        return this.getCurrentSessionFactory().openSession(connection);
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.getCurrentSessionFactory().openSession(connection, interceptor);
    }

    public Session getCurrentSession() throws HibernateException {
        return this.getCurrentSessionFactory().getCurrentSession();
    }

    public StatelessSession openStatelessSession() {
        return this.getCurrentSessionFactory().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.getCurrentSessionFactory().openStatelessSession(connection);
    }

    public ClassMetadata getClassMetadata(Class entityClass) {
        return this.getCurrentSessionFactory().getClassMetadata(entityClass);
    }

    public ClassMetadata getClassMetadata(String entityName) {
        return this.getCurrentSessionFactory().getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) {
        return this.getCurrentSessionFactory().getCollectionMetadata(roleName);
    }

    public Map<String, ClassMetadata> getAllClassMetadata() {
        return this.getCurrentSessionFactory().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() {
        return this.getCurrentSessionFactory().getAllCollectionMetadata();
    }

    public Statistics getStatistics() {
        return this.getCurrentSessionFactory().getStatistics();
    }

    public void close() throws HibernateException {
        this.getCurrentSessionFactory().close();
    }

    public boolean isClosed() {
        return this.getCurrentSessionFactory().isClosed();
    }

    public Cache getCache() {
        return this.getCurrentSessionFactory().getCache();
    }

    @Deprecated
    public void evict(Class persistentClass) throws HibernateException {
        this.getCurrentSessionFactory().evict(persistentClass);
    }

    @Deprecated
    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getCurrentSessionFactory().evict(persistentClass, id);
    }

    @Deprecated
    public void evictEntity(String entityName) throws HibernateException {
        this.getCurrentSessionFactory().evictEntity(entityName);
    }

    @Deprecated
    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getCurrentSessionFactory().evictEntity(entityName, id);
    }

    @Deprecated
    public void evictCollection(String roleName) throws HibernateException {
        this.getCurrentSessionFactory().evictCollection(roleName);
    }

    @Deprecated
    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getCurrentSessionFactory().evictCollection(roleName, id);
    }

    @Deprecated
    public void evictQueries(String cacheRegion) throws HibernateException {
        this.getCurrentSessionFactory().evictQueries(cacheRegion);
    }

    @Deprecated
    public void evictQueries() throws HibernateException {
        this.getCurrentSessionFactory().evictQueries();
    }

    public Set getDefinedFilterNames() {
        return this.getCurrentSessionFactory().getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.getCurrentSessionFactory().getFilterDefinition(filterName);
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.getCurrentSessionFactory().containsFetchProfileDefinition(name);
    }

    public TypeHelper getTypeHelper() {
        return this.getCurrentSessionFactory().getTypeHelper();
    }

    public Reference getReference() throws NamingException {
        return this.getCurrentSessionFactory().getReference();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public TypeResolver getTypeResolver() {
        return this.getCurrentSessionFactoryImplementor().getTypeResolver();
    }

    public Properties getProperties() {
        return this.getCurrentSessionFactoryImplementor().getProperties();
    }

    public EntityPersister getEntityPersister(String entityName) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getEntityPersister(entityName);
    }

    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getCollectionPersister(role);
    }

    public Dialect getDialect() {
        return this.getCurrentSessionFactoryImplementor().getDialect();
    }

    public Interceptor getInterceptor() {
        return this.getCurrentSessionFactoryImplementor().getInterceptor();
    }

    public QueryPlanCache getQueryPlanCache() {
        return this.getCurrentSessionFactoryImplementor().getQueryPlanCache();
    }

    public Type[] getReturnTypes(String queryString) throws HibernateException {
        return this.getCurrentSessionFactoryImplementor().getReturnTypes(queryString);
    }

    public String[] getReturnAliases(String queryString) throws HibernateException {
        return this.getCurrentSessionFactoryImplementor().getReturnAliases(queryString);
    }

    public ConnectionProvider getConnectionProvider() {
        return this.getCurrentSessionFactoryImplementor().getConnectionProvider();
    }

    public String[] getImplementors(String className) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getImplementors(className);
    }

    public String getImportedClassName(String name) {
        return this.getCurrentSessionFactoryImplementor().getImportedClassName(name);
    }

    public TransactionManager getTransactionManager() {
        return this.getCurrentSessionFactoryImplementor().getTransactionManager();
    }

    public QueryCache getQueryCache() {
        return this.getCurrentSessionFactoryImplementor().getQueryCache();
    }

    public QueryCache getQueryCache(String regionName) throws HibernateException {
        return this.getCurrentSessionFactoryImplementor().getQueryCache(regionName);
    }

    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.getCurrentSessionFactoryImplementor().getUpdateTimestampsCache();
    }

    public StatisticsImplementor getStatisticsImplementor() {
        return this.getCurrentSessionFactoryImplementor().getStatisticsImplementor();
    }

    public NamedQueryDefinition getNamedQuery(String queryName) {
        return this.getCurrentSessionFactoryImplementor().getNamedQuery(queryName);
    }

    public NamedSQLQueryDefinition getNamedSQLQuery(String queryName) {
        return this.getCurrentSessionFactoryImplementor().getNamedSQLQuery(queryName);
    }

    public ResultSetMappingDefinition getResultSetMapping(String name) {
        return this.getCurrentSessionFactoryImplementor().getResultSetMapping(name);
    }

    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return this.getCurrentSessionFactoryImplementor().getIdentifierGenerator(rootEntityName);
    }

    public Region getSecondLevelCacheRegion(String regionName) {
        return this.getCurrentSessionFactoryImplementor().getSecondLevelCacheRegion(regionName);
    }

    public Map getAllSecondLevelCacheRegions() {
        return this.getCurrentSessionFactoryImplementor().getAllSecondLevelCacheRegions();
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getCurrentSessionFactoryImplementor().getSQLExceptionConverter();
    }

    public Settings getSettings() {
        return this.getCurrentSessionFactoryImplementor().getSettings();
    }

    public Session openTemporarySession() throws HibernateException {
        return this.getCurrentSessionFactoryImplementor().openTemporarySession();
    }

    public Session openSession(Connection connection, boolean flushBeforeCompletionEnabled, boolean autoCloseSessionEnabled, ConnectionReleaseMode connectionReleaseMode) throws HibernateException {
        return this.getCurrentSessionFactoryImplementor().openSession(connection, flushBeforeCompletionEnabled, autoCloseSessionEnabled, connectionReleaseMode);
    }

    public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.getCurrentSessionFactoryImplementor().getCollectionRolesByEntityParticipant(entityName);
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.getCurrentSessionFactoryImplementor().getEntityNotFoundDelegate();
    }

    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.getCurrentSessionFactoryImplementor().getSqlFunctionRegistry();
    }

    public FetchProfile getFetchProfile(String name) {
        return this.getCurrentSessionFactoryImplementor().getFetchProfile(name);
    }

    public SessionFactoryObserver getFactoryObserver() {
        return this.getCurrentSessionFactoryImplementor().getFactoryObserver();
    }

    @Deprecated
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.getCurrentSessionFactoryImplementor().getIdentifierGeneratorFactory();
    }

    public Type getIdentifierType(String className) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getIdentifierType(className);
    }

    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getIdentifierPropertyName(className);
    }

    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.getCurrentSessionFactoryImplementor().getReferencedPropertyType(className, propertyName);
    }

    public void afterPropertiesSet() {
        SessionFactoryImplementor sessionFactory = this.getCurrentSessionFactoryImplementor();
        this.updateCurrentSessionContext((SessionFactory)sessionFactory);
    }

    private void updateCurrentSessionContext(SessionFactory sessionFactory) {
        CurrentSessionContext ssc = this.createCurrentSessionContext();
        try {
            Class<?> sessionFactoryClass = sessionFactory.getClass();
            Field currentSessionContextField = sessionFactoryClass.getDeclaredField("currentSessionContext");
            if (currentSessionContextField != null) {
                ReflectionUtils.makeAccessible((Field)currentSessionContextField);
                currentSessionContextField.set(sessionFactory, ssc);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected CurrentSessionContext createCurrentSessionContext() {
        Class<SpringSessionContext> sessionContextClass = this.currentSessionContextClass;
        if (sessionContextClass == null) {
            sessionContextClass = SpringSessionContext.class;
        }
        try {
            Constructor constructor = sessionContextClass.getConstructor(SessionFactoryImplementor.class);
            return (CurrentSessionContext)BeanUtils.instantiateClass(constructor, (Object[])new Object[]{this});
        }
        catch (NoSuchMethodException e) {
            return new SpringSessionContext((SessionFactoryImplementor)this);
        }
    }

    public Object getWrappedObject() {
        return this.getCurrentSessionFactory();
    }
}

