/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.events;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.DefaultFlushEventListener;

public class PatchedDefaultFlushEventListener
extends DefaultFlushEventListener {
    private static final long serialVersionUID = -7413770767669684078L;
    private static final Log LOG = LogFactory.getLog(PatchedDefaultFlushEventListener.class);

    protected void performExecutions(EventSource session) throws HibernateException {
        session.getPersistenceContext().setFlushing(true);
        try {
            session.getJDBCContext().getConnectionManager().flushBeginning();
            session.getActionQueue().prepareActions();
            session.getActionQueue().executeActions();
        }
        catch (HibernateException he) {
            LOG.error((Object)"Could not synchronize database state with session", (Throwable)he);
            throw he;
        }
        finally {
            session.getPersistenceContext().setFlushing(false);
            session.getJDBCContext().getConnectionManager().flushEnding();
        }
    }
}

