/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import grails.validation.DeferredBindingActions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.lifecycle.ShutdownOperations;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernatePersistenceContextInterceptor
implements PersistenceContextInterceptor {
    private static final Log LOG = LogFactory.getLog(HibernatePersistenceContextInterceptor.class);
    private SessionFactory sessionFactory;
    private static ThreadLocal<Boolean> participate;
    private static ThreadLocal<Integer> nestingCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        DeferredBindingActions.clear();
        if (this.decNestingCount() > 0 || this.getParticipate()) {
            return;
        }
        try {
            SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.getSessionFactory());
            LOG.debug((Object)"Closing single Hibernate session in GrailsDispatcherServlet");
            try {
                Session session = holder.getSession();
                SessionFactoryUtils.closeSession((Session)session);
            }
            catch (RuntimeException ex) {
                LOG.error((Object)"Unexpected exception on closing Hibernate Session", (Throwable)ex);
            }
        }
        finally {
            AbstractSavePersistentMethod.clearDisabledValidations();
        }
    }

    public void disconnect() {
        try {
            this.getSession(false).disconnect();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void reconnect() {
        this.getSession().reconnect();
    }

    public void flush() {
        this.getSession().flush();
    }

    public void clear() {
        this.getSession().clear();
    }

    public void setReadOnly() {
        this.getSession().setFlushMode(FlushMode.MANUAL);
    }

    public void setReadWrite() {
        this.getSession().setFlushMode(FlushMode.AUTO);
    }

    public boolean isOpen() {
        try {
            return this.getSession(false).isOpen();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void init() {
        if (this.incNestingCount() > 1) {
            return;
        }
        SessionFactory sf = this.getSessionFactory();
        if (TransactionSynchronizationManager.hasResource((Object)sf)) {
            this.setParticipate(true);
        } else {
            this.setParticipate(false);
            LOG.debug((Object)"Opening single Hibernate session in HibernatePersistenceContextInterceptor");
            Session session = this.getSession();
            GrailsHibernateUtil.enableDynamicFilterEnablerIfPresent(sf, session);
            session.setFlushMode(FlushMode.AUTO);
            TransactionSynchronizationManager.bindResource((Object)sf, (Object)new SessionHolder(session));
        }
    }

    private Session getSession() {
        return this.getSession(true);
    }

    private Session getSession(boolean allowCreate) {
        return SessionFactoryUtils.getSession((SessionFactory)this.getSessionFactory(), (boolean)allowCreate);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private int incNestingCount() {
        int value = nestingCount.get() + 1;
        nestingCount.set(value);
        return value;
    }

    private int decNestingCount() {
        int value = nestingCount.get() - 1;
        if (value < 0) {
            value = 0;
        }
        nestingCount.set(value);
        return value;
    }

    private void setParticipate(boolean flag) {
        participate.set(flag);
    }

    private boolean getParticipate() {
        return participate.get();
    }

    static {
        ShutdownOperations.addOperation((Runnable)new Runnable(){

            public void run() {
                participate.remove();
                nestingCount.remove();
            }
        });
        participate = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        nestingCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
    }
}

