/*
 * Decompiled with CFR 0.152.
 */
package grails.orm;

import grails.orm.PagedResultList;
import grails.orm.RlikeExpression;
import grails.util.CollectionUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTemplate;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.query.HibernateCriterionAdapter;
import org.codehaus.groovy.grails.orm.hibernate.query.HibernateProjectionAdapter;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.ProjectionList;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.TypeHelper;
import org.hibernate.criterion.AggregateProjection;
import org.hibernate.criterion.CountProjection;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.IdentifierProjection;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.PropertyProjection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.beans.BeanUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateCriteriaBuilder
extends GroovyObjectSupport
implements org.grails.datastore.mapping.query.api.Criteria,
ProjectionList {
    public static final String AND = "and";
    public static final String IS_NULL = "isNull";
    public static final String IS_NOT_NULL = "isNotNull";
    public static final String NOT = "not";
    public static final String OR = "or";
    public static final String ID_EQUALS = "idEq";
    public static final String IS_EMPTY = "isEmpty";
    public static final String IS_NOT_EMPTY = "isNotEmpty";
    public static final String RLIKE = "rlike";
    public static final String BETWEEN = "between";
    public static final String EQUALS = "eq";
    public static final String EQUALS_PROPERTY = "eqProperty";
    public static final String GREATER_THAN = "gt";
    public static final String GREATER_THAN_PROPERTY = "gtProperty";
    public static final String GREATER_THAN_OR_EQUAL = "ge";
    public static final String GREATER_THAN_OR_EQUAL_PROPERTY = "geProperty";
    public static final String ILIKE = "ilike";
    public static final String IN = "in";
    public static final String LESS_THAN = "lt";
    public static final String LESS_THAN_PROPERTY = "ltProperty";
    public static final String LESS_THAN_OR_EQUAL = "le";
    public static final String LESS_THAN_OR_EQUAL_PROPERTY = "leProperty";
    public static final String LIKE = "like";
    public static final String NOT_EQUAL = "ne";
    public static final String NOT_EQUAL_PROPERTY = "neProperty";
    public static final String SIZE_EQUALS = "sizeEq";
    public static final String ORDER_DESCENDING = "desc";
    public static final String ORDER_ASCENDING = "asc";
    private static final String ROOT_DO_CALL = "doCall";
    private static final String ROOT_CALL = "call";
    private static final String LIST_CALL = "list";
    private static final String LIST_DISTINCT_CALL = "listDistinct";
    private static final String COUNT_CALL = "count";
    private static final String GET_CALL = "get";
    private static final String SCROLL_CALL = "scroll";
    private static final String SET_RESULT_TRANSFORMER_CALL = "setResultTransformer";
    private static final String PROJECTIONS = "projections";
    private SessionFactory sessionFactory;
    private Session hibernateSession;
    private Class<?> targetClass;
    private Criteria criteria;
    private MetaClass criteriaMetaClass;
    private boolean uniqueResult = false;
    private List<LogicalExpression> logicalExpressionStack = new ArrayList<LogicalExpression>();
    private List<String> associationStack = new ArrayList<String>();
    private boolean participate;
    private boolean scroll;
    private boolean count;
    private org.hibernate.criterion.ProjectionList projectionList = Projections.projectionList();
    private List<String> aliasStack = new ArrayList<String>();
    private List<Criteria> aliasInstanceStack = new ArrayList<Criteria>();
    private Map<String, String> aliasMap = new HashMap<String, String>();
    private static final String ALIAS = "_alias";
    private ResultTransformer resultTransformer;
    private int aliasCount;
    private boolean paginationEnabledList = false;
    private List<Order> orderEntries;
    private GrailsApplication grailsApplication;
    public static final Type BOOLEAN = StandardBasicTypes.BOOLEAN;
    public static final Type YES_NO = StandardBasicTypes.YES_NO;
    public static final Type BYTE = StandardBasicTypes.BYTE;
    public static final Type CHARACTER = StandardBasicTypes.CHARACTER;
    public static final Type SHORT = StandardBasicTypes.SHORT;
    public static final Type INTEGER = StandardBasicTypes.INTEGER;
    public static final Type LONG = StandardBasicTypes.LONG;
    public static final Type FLOAT = StandardBasicTypes.FLOAT;
    public static final Type DOUBLE = StandardBasicTypes.DOUBLE;
    public static final Type BIG_DECIMAL = StandardBasicTypes.BIG_DECIMAL;
    public static final Type BIG_INTEGER = StandardBasicTypes.BIG_INTEGER;
    public static final Type STRING = StandardBasicTypes.STRING;
    public static final Type NUMERIC_BOOLEAN = StandardBasicTypes.NUMERIC_BOOLEAN;
    public static final Type TRUE_FALSE = StandardBasicTypes.TRUE_FALSE;
    public static final Type URL = StandardBasicTypes.URL;
    public static final Type TIME = StandardBasicTypes.TIME;
    public static final Type DATE = StandardBasicTypes.DATE;
    public static final Type TIMESTAMP = StandardBasicTypes.TIMESTAMP;
    public static final Type CALENDAR = StandardBasicTypes.CALENDAR;
    public static final Type CALENDAR_DATE = StandardBasicTypes.CALENDAR_DATE;
    public static final Type CLASS = StandardBasicTypes.CLASS;
    public static final Type LOCALE = StandardBasicTypes.LOCALE;
    public static final Type CURRENCY = StandardBasicTypes.CURRENCY;
    public static final Type TIMEZONE = StandardBasicTypes.TIMEZONE;
    public static final Type UUID_BINARY = StandardBasicTypes.UUID_BINARY;
    public static final Type UUID_CHAR = StandardBasicTypes.UUID_CHAR;
    public static final Type BINARY = StandardBasicTypes.BINARY;
    public static final Type WRAPPER_BINARY = StandardBasicTypes.WRAPPER_BINARY;
    public static final Type IMAGE = StandardBasicTypes.IMAGE;
    public static final Type BLOB = StandardBasicTypes.BLOB;
    public static final Type MATERIALIZED_BLOB = StandardBasicTypes.MATERIALIZED_BLOB;
    public static final Type WRAPPER_MATERIALIZED_BLOB = StandardBasicTypes.WRAPPER_MATERIALIZED_BLOB;
    public static final Type CHAR_ARRAY = StandardBasicTypes.CHAR_ARRAY;
    public static final Type CHARACTER_ARRAY = StandardBasicTypes.CHARACTER_ARRAY;
    public static final Type TEXT = StandardBasicTypes.TEXT;
    public static final Type CLOB = StandardBasicTypes.CLOB;
    public static final Type MATERIALIZED_CLOB = StandardBasicTypes.MATERIALIZED_CLOB;
    public static final Type WRAPPER_CHARACTERS_CLOB = StandardBasicTypes.WRAPPER_CHARACTERS_CLOB;
    public static final Type CHARACTERS_CLOB = StandardBasicTypes.CHARACTERS_CLOB;
    public static final Type SERIALIZABLE = StandardBasicTypes.SERIALIZABLE;

    public HibernateCriteriaBuilder(Class targetClass, SessionFactory sessionFactory) {
        this.targetClass = targetClass;
        this.sessionFactory = sessionFactory;
    }

    public HibernateCriteriaBuilder(Class targetClass, SessionFactory sessionFactory, boolean uniqueResult) {
        this.targetClass = targetClass;
        this.sessionFactory = sessionFactory;
        this.uniqueResult = uniqueResult;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    public Criteria getInstance() {
        return this.criteria;
    }

    public void setUniqueResult(boolean uniqueResult) {
        this.uniqueResult = uniqueResult;
    }

    public ProjectionList property(String propertyName) {
        return this.property(propertyName, null);
    }

    public ProjectionList property(String propertyName, String alias) {
        PropertyProjection propertyProjection = Projections.property((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)propertyProjection, alias);
        return this;
    }

    protected void addProjectionToList(Projection propertyProjection, String alias) {
        if (alias != null) {
            this.projectionList.add(propertyProjection, alias);
        } else {
            this.projectionList.add(propertyProjection);
        }
    }

    protected void sqlProjection(String sql, String columnAlias, Type type) {
        this.sqlProjection(sql, CollectionUtils.newList((Object[])new String[]{columnAlias}), CollectionUtils.newList((Object[])new Type[]{type}));
    }

    protected void sqlProjection(String sql, List<String> columnAliases, List<Type> types) {
        this.projectionList.add(Projections.sqlProjection((String)sql, (String[])columnAliases.toArray(new String[columnAliases.size()]), (Type[])types.toArray(new Type[types.size()])));
    }

    protected void sqlGroupProjection(String sql, String groupBy, List<String> columnAliases, List<Type> types) {
        this.projectionList.add(Projections.sqlGroupProjection((String)sql, (String)groupBy, (String[])columnAliases.toArray(new String[columnAliases.size()]), (Type[])types.toArray(new Type[types.size()])));
    }

    public ProjectionList distinct(String propertyName) {
        this.distinct(propertyName, null);
        return this;
    }

    public ProjectionList distinct(String propertyName, String alias) {
        Projection proj = Projections.distinct((Projection)Projections.property((String)this.calculatePropertyName(propertyName)));
        this.addProjectionToList(proj, alias);
        return this;
    }

    public ProjectionList distinct(Collection propertyNames) {
        return this.distinct(propertyNames, null);
    }

    public ProjectionList distinct(Collection propertyNames, String alias) {
        org.hibernate.criterion.ProjectionList list = Projections.projectionList();
        for (Object o : propertyNames) {
            list.add((Projection)Projections.property((String)this.calculatePropertyName(o.toString())));
        }
        Projection proj = Projections.distinct((Projection)list);
        this.addProjectionToList(proj, alias);
        return this;
    }

    public ProjectionList avg(String propertyName) {
        return this.avg(propertyName, null);
    }

    public ProjectionList avg(String propertyName, String alias) {
        AggregateProjection aggregateProjection = Projections.avg((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)aggregateProjection, alias);
        return this;
    }

    public void join(String associationPath) {
        this.criteria.setFetchMode(this.calculatePropertyName(associationPath), FetchMode.JOIN);
    }

    public void lock(boolean shouldLock) {
        String lastAlias = this.getLastAlias();
        if (shouldLock) {
            if (lastAlias != null) {
                this.criteria.setLockMode(lastAlias, LockMode.PESSIMISTIC_WRITE);
            } else {
                this.criteria.setLockMode(LockMode.PESSIMISTIC_WRITE);
            }
        } else if (lastAlias != null) {
            this.criteria.setLockMode(lastAlias, LockMode.NONE);
        } else {
            this.criteria.setLockMode(LockMode.NONE);
        }
    }

    public void select(String associationPath) {
        this.criteria.setFetchMode(this.calculatePropertyName(associationPath), FetchMode.SELECT);
    }

    public void cache(boolean shouldCache) {
        this.criteria.setCacheable(shouldCache);
    }

    private String calculatePropertyName(String propertyName) {
        String lastAlias = this.getLastAlias();
        if (lastAlias != null) {
            return lastAlias + '.' + propertyName;
        }
        return propertyName;
    }

    private String getLastAlias() {
        if (this.aliasStack.size() > 0) {
            return this.aliasStack.get(this.aliasStack.size() - 1).toString();
        }
        return null;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    private Object calculatePropertyValue(Object propertyValue) {
        if (propertyValue instanceof CharSequence) {
            return propertyValue.toString();
        }
        if (propertyValue instanceof QueryableCriteria) {
            propertyValue = HibernateCriteriaBuilder.getHibernateDetachedCriteria((QueryableCriteria)propertyValue);
        } else if (propertyValue instanceof Closure) {
            propertyValue = HibernateCriteriaBuilder.getHibernateDetachedCriteria(new grails.gorm.DetachedCriteria(this.targetClass).build((Closure)propertyValue));
        }
        return propertyValue;
    }

    public static DetachedCriteria getHibernateDetachedCriteria(QueryableCriteria<?> queryableCriteria) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass((Class)queryableCriteria.getPersistentEntity().getJavaClass());
        HibernateCriteriaBuilder.populateHibernateDetachedCriteria(detachedCriteria, queryableCriteria);
        return detachedCriteria;
    }

    private static void populateHibernateDetachedCriteria(DetachedCriteria detachedCriteria, QueryableCriteria<?> queryableCriteria) {
        List criteriaList = queryableCriteria.getCriteria();
        for (Query.Criterion criterion : criteriaList) {
            Criterion hibernateCriterion = new HibernateCriterionAdapter(criterion).toHibernateCriterion(null);
            if (hibernateCriterion == null) continue;
            detachedCriteria.add(hibernateCriterion);
        }
        List projections = queryableCriteria.getProjections();
        org.hibernate.criterion.ProjectionList projectionList = Projections.projectionList();
        for (Query.Projection projection : projections) {
            Projection hibernateProjection = new HibernateProjectionAdapter(projection).toHibernateProjection();
            if (hibernateProjection == null) continue;
            projectionList.add(hibernateProjection);
        }
        detachedCriteria.setProjection((Projection)projectionList);
    }

    public void count(String propertyName) {
        this.count(propertyName, null);
    }

    public void count(String propertyName, String alias) {
        CountProjection proj = Projections.count((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
    }

    public ProjectionList id() {
        IdentifierProjection proj = Projections.id();
        this.addProjectionToList((Projection)proj, null);
        return this;
    }

    public ProjectionList count() {
        return this.rowCount();
    }

    public ProjectionList countDistinct(String propertyName) {
        return this.countDistinct(propertyName, null);
    }

    public ProjectionList distinct() {
        return this;
    }

    public ProjectionList countDistinct(String propertyName, String alias) {
        CountProjection proj = Projections.countDistinct((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
        return this;
    }

    public void groupProperty(String propertyName) {
        this.groupProperty(propertyName, null);
    }

    public void groupProperty(String propertyName, String alias) {
        PropertyProjection proj = Projections.groupProperty((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
    }

    public ProjectionList max(String propertyName) {
        return this.max(propertyName, null);
    }

    public ProjectionList max(String propertyName, String alias) {
        AggregateProjection proj = Projections.max((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
        return this;
    }

    public ProjectionList min(String propertyName) {
        return this.min(propertyName, null);
    }

    public ProjectionList min(String propertyName, String alias) {
        AggregateProjection aggregateProjection = Projections.min((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)aggregateProjection, alias);
        return this;
    }

    public ProjectionList rowCount() {
        return this.rowCount(null);
    }

    public ProjectionList rowCount(String alias) {
        Projection proj = Projections.rowCount();
        this.addProjectionToList(proj, alias);
        return this;
    }

    public ProjectionList sum(String propertyName) {
        return this.sum(propertyName, null);
    }

    public ProjectionList sum(String propertyName, String alias) {
        AggregateProjection proj = Projections.sum((String)this.calculatePropertyName(propertyName));
        this.addProjectionToList((Projection)proj, alias);
        return this;
    }

    public void fetchMode(String associationPath, FetchMode fetchMode) {
        if (this.criteria != null) {
            this.criteria.setFetchMode(associationPath, fetchMode);
        }
    }

    public void resultTransformer(ResultTransformer transformer) {
        if (this.criteria == null) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [resultTransformer] not supported here"));
        }
        this.resultTransformer = transformer;
    }

    public Criteria createAlias(String associationPath, String alias) {
        return this.criteria.createAlias(associationPath, alias);
    }

    public Criteria createAlias(String associationPath, String alias, int joinType) {
        return this.criteria.createAlias(associationPath, alias, joinType);
    }

    public org.grails.datastore.mapping.query.api.Criteria eqProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [eqProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        this.addToCriteria((Criterion)Restrictions.eqProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria neProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [neProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        this.addToCriteria((Criterion)Restrictions.neProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria gtProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [gtProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        this.addToCriteria((Criterion)Restrictions.gtProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria geProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [geProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        this.addToCriteria((Criterion)Restrictions.geProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria ltProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [ltProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        this.addToCriteria((Criterion)Restrictions.ltProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria leProperty(String propertyName, String otherPropertyName) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [leProperty] with propertyName [" + propertyName + "] and other property name [" + otherPropertyName + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        otherPropertyName = this.calculatePropertyName(otherPropertyName);
        this.addToCriteria((Criterion)Restrictions.leProperty((String)propertyName, (String)otherPropertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria eqAll(String propertyName, Closure<?> propertyValue) {
        return this.eqAll(propertyName, (QueryableCriteria)new grails.gorm.DetachedCriteria(this.targetClass).build(propertyValue));
    }

    public org.grails.datastore.mapping.query.api.Criteria gtAll(String propertyName, Closure<?> propertyValue) {
        return this.gtAll(propertyName, (QueryableCriteria)new grails.gorm.DetachedCriteria(this.targetClass).build(propertyValue));
    }

    public org.grails.datastore.mapping.query.api.Criteria ltAll(String propertyName, Closure<?> propertyValue) {
        return this.ltAll(propertyName, (QueryableCriteria)new grails.gorm.DetachedCriteria(this.targetClass).build(propertyValue));
    }

    public org.grails.datastore.mapping.query.api.Criteria geAll(String propertyName, Closure<?> propertyValue) {
        return this.geAll(propertyName, (QueryableCriteria)new grails.gorm.DetachedCriteria(this.targetClass).build(propertyValue));
    }

    public org.grails.datastore.mapping.query.api.Criteria leAll(String propertyName, Closure<?> propertyValue) {
        return this.leAll(propertyName, (QueryableCriteria)new grails.gorm.DetachedCriteria(this.targetClass).build(propertyValue));
    }

    public org.grails.datastore.mapping.query.api.Criteria eqAll(String propertyName, QueryableCriteria propertyValue) {
        this.addToCriteria(Property.forName((String)propertyName).eqAll(HibernateCriteriaBuilder.getHibernateDetachedCriteria(propertyValue)));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria gtAll(String propertyName, QueryableCriteria propertyValue) {
        this.addToCriteria(Property.forName((String)propertyName).gtAll(HibernateCriteriaBuilder.getHibernateDetachedCriteria(propertyValue)));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria ltAll(String propertyName, QueryableCriteria propertyValue) {
        this.addToCriteria(Property.forName((String)propertyName).ltAll(HibernateCriteriaBuilder.getHibernateDetachedCriteria(propertyValue)));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria geAll(String propertyName, QueryableCriteria propertyValue) {
        this.addToCriteria(Property.forName((String)propertyName).geAll(HibernateCriteriaBuilder.getHibernateDetachedCriteria(propertyValue)));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria leAll(String propertyName, QueryableCriteria propertyValue) {
        this.addToCriteria(Property.forName((String)propertyName).leAll(HibernateCriteriaBuilder.getHibernateDetachedCriteria(propertyValue)));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria gt(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [gt] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        Object gt = (propertyValue = this.calculatePropertyValue(propertyValue)) instanceof DetachedCriteria ? Property.forName((String)propertyName).gt((DetachedCriteria)propertyValue) : Restrictions.gt((String)propertyName, (Object)propertyValue);
        this.addToCriteria((Criterion)gt);
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria lte(String s, Object o) {
        return this.le(s, o);
    }

    public org.grails.datastore.mapping.query.api.Criteria ge(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [ge] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        Object ge = (propertyValue = this.calculatePropertyValue(propertyValue)) instanceof DetachedCriteria ? Property.forName((String)propertyName).ge((DetachedCriteria)propertyValue) : Restrictions.ge((String)propertyName, (Object)propertyValue);
        this.addToCriteria((Criterion)ge);
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria lt(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [lt] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        Object lt = (propertyValue = this.calculatePropertyValue(propertyValue)) instanceof DetachedCriteria ? Property.forName((String)propertyName).lt((DetachedCriteria)propertyValue) : Restrictions.lt((String)propertyName, (Object)propertyValue);
        this.addToCriteria((Criterion)lt);
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria le(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [le] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        Object le = (propertyValue = this.calculatePropertyValue(propertyValue)) instanceof DetachedCriteria ? Property.forName((String)propertyName).le((DetachedCriteria)propertyValue) : Restrictions.le((String)propertyName, (Object)propertyValue);
        this.addToCriteria((Criterion)le);
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria idEquals(Object o) {
        return this.idEq(o);
    }

    public org.grails.datastore.mapping.query.api.Criteria isEmpty(String property) {
        String propertyName = this.calculatePropertyName(property);
        this.addToCriteria(Restrictions.isEmpty((String)propertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria isNotEmpty(String property) {
        String propertyName = this.calculatePropertyName(property);
        this.addToCriteria(Restrictions.isNotEmpty((String)propertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria isNull(String property) {
        String propertyName = this.calculatePropertyName(property);
        this.addToCriteria(Restrictions.isNull((String)propertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria isNotNull(String property) {
        String propertyName = this.calculatePropertyName(property);
        this.addToCriteria(Restrictions.isNotNull((String)propertyName));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria eq(String propertyName, Object propertyValue) {
        return this.eq(propertyName, propertyValue, Collections.emptyMap());
    }

    public org.grails.datastore.mapping.query.api.Criteria idEq(Object o) {
        return this.eq("id", o);
    }

    public org.grails.datastore.mapping.query.api.Criteria eq(Map params, String propertyName, Object propertyValue) {
        return this.eq(propertyName, propertyValue, params);
    }

    public org.grails.datastore.mapping.query.api.Criteria eq(String propertyName, Object propertyValue, Map params) {
        Object ignoreCase;
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [eq] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        Object eq = (propertyValue = this.calculatePropertyValue(propertyValue)) instanceof DetachedCriteria ? Property.forName((String)propertyName).eq((DetachedCriteria)propertyValue) : Restrictions.eq((String)propertyName, (Object)propertyValue);
        if (params != null && eq instanceof SimpleExpression && (ignoreCase = params.get("ignoreCase")) instanceof Boolean && ((Boolean)ignoreCase).booleanValue()) {
            eq = eq.ignoreCase();
        }
        this.addToCriteria((Criterion)eq);
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria sqlRestriction(String sqlRestriction) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sqlRestriction] with value [" + sqlRestriction + "] not allowed here."));
        }
        return this.sqlRestriction(sqlRestriction, Collections.EMPTY_LIST);
    }

    public org.grails.datastore.mapping.query.api.Criteria sqlRestriction(String sqlRestriction, List<?> values) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sqlRestriction] with value [" + sqlRestriction + "] not allowed here."));
        }
        int numberOfParameters = values.size();
        Type[] typesArray = new Type[numberOfParameters];
        Object[] valuesArray = new Object[numberOfParameters];
        if (numberOfParameters > 0) {
            TypeHelper typeHelper = this.sessionFactory.getTypeHelper();
            for (int i = 0; i < typesArray.length; ++i) {
                Object value = values.get(i);
                typesArray[i] = typeHelper.basic(value.getClass());
                valuesArray[i] = value;
            }
        }
        this.addToCriteria(Restrictions.sqlRestriction((String)sqlRestriction, (Object[])valuesArray, (Type[])typesArray));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria like(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [like] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        this.addToCriteria((Criterion)Restrictions.like((String)propertyName, (Object)propertyValue));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria rlike(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [rlike] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        this.addToCriteria(new RlikeExpression(propertyName, propertyValue));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria ilike(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [ilike] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        this.addToCriteria(Restrictions.ilike((String)propertyName, (Object)propertyValue));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria in(String propertyName, Collection values) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [in] with propertyName [" + propertyName + "] and values [" + values + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        this.addToCriteria(Restrictions.in((String)propertyName, (Collection)(values == null ? Collections.EMPTY_LIST : values)));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria inList(String propertyName, Collection values) {
        return this.in(propertyName, values);
    }

    public org.grails.datastore.mapping.query.api.Criteria inList(String propertyName, Object[] values) {
        return this.in(propertyName, values);
    }

    public org.grails.datastore.mapping.query.api.Criteria in(String propertyName, Object[] values) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [in] with propertyName [" + propertyName + "] and values [" + values + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        this.addToCriteria(Restrictions.in((String)propertyName, (Object[])values));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria order(String propertyName) {
        if (this.criteria == null) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [order] with propertyName [" + propertyName + "]not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        Order o = Order.asc((String)propertyName);
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.criteria.addOrder(o);
        }
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria order(Order o) {
        if (this.criteria == null) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [order] not allowed here."));
        }
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.criteria.addOrder(o);
        }
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria order(String propertyName, String direction) {
        if (this.criteria == null) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [order] with propertyName [" + propertyName + "]not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        Order o = direction.equals(ORDER_DESCENDING) ? Order.desc((String)propertyName) : Order.asc((String)propertyName);
        if (this.paginationEnabledList) {
            this.orderEntries.add(o);
        } else {
            this.criteria.addOrder(o);
        }
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria sizeEq(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeEq] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        this.addToCriteria(Restrictions.sizeEq((String)propertyName, (int)size));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria sizeGt(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeGt] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        this.addToCriteria(Restrictions.sizeGt((String)propertyName, (int)size));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria sizeGe(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeGe] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        this.addToCriteria(Restrictions.sizeGe((String)propertyName, (int)size));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria sizeLe(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeLe] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        this.addToCriteria(Restrictions.sizeLe((String)propertyName, (int)size));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria sizeLt(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeLt] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        this.addToCriteria(Restrictions.sizeLt((String)propertyName, (int)size));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria sizeNe(String propertyName, int size) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [sizeNe] with propertyName [" + propertyName + "] and size [" + size + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        this.addToCriteria(Restrictions.sizeNe((String)propertyName, (int)size));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria ne(String propertyName, Object propertyValue) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [ne] with propertyName [" + propertyName + "] and value [" + propertyValue + "] not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        propertyValue = this.calculatePropertyValue(propertyValue);
        this.addToCriteria((Criterion)Restrictions.ne((String)propertyName, (Object)propertyValue));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria notEqual(String propertyName, Object propertyValue) {
        return this.ne(propertyName, propertyValue);
    }

    public org.grails.datastore.mapping.query.api.Criteria between(String propertyName, Object lo, Object hi) {
        if (!this.validateSimpleExpression()) {
            this.throwRuntimeException(new IllegalArgumentException("Call to [between] with propertyName [" + propertyName + "]  not allowed here."));
        }
        propertyName = this.calculatePropertyName(propertyName);
        this.addToCriteria(Restrictions.between((String)propertyName, (Object)lo, (Object)hi));
        return this;
    }

    public org.grails.datastore.mapping.query.api.Criteria gte(String s, Object o) {
        return this.ge(s, o);
    }

    private boolean validateSimpleExpression() {
        return this.criteria != null;
    }

    public Object invokeMethod(String name, Object obj) {
        MetaMethod metaMethod;
        Object[] objectArray;
        if (obj.getClass().isArray()) {
            objectArray = (Object[])obj;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = obj;
        }
        Object[] args = objectArray;
        if (this.paginationEnabledList && SET_RESULT_TRANSFORMER_CALL.equals(name) && args.length == 1 && args[0] instanceof ResultTransformer) {
            this.resultTransformer = (ResultTransformer)args[0];
            return null;
        }
        if (this.isCriteriaConstructionMethod(name, args)) {
            Object result;
            if (this.criteria != null) {
                this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] not supported here"));
            }
            if (name.equals(GET_CALL)) {
                this.uniqueResult = true;
            } else if (name.equals(SCROLL_CALL)) {
                this.scroll = true;
            } else if (name.equals(COUNT_CALL)) {
                this.count = true;
            } else if (name.equals(LIST_DISTINCT_CALL)) {
                this.resultTransformer = CriteriaSpecification.DISTINCT_ROOT_ENTITY;
            }
            this.createCriteriaInstance();
            if (name.equals(LIST_CALL) && args.length == 2) {
                this.paginationEnabledList = true;
                this.orderEntries = new ArrayList<Order>();
                this.invokeClosureNode(args[1]);
            } else {
                this.invokeClosureNode(args[0]);
            }
            if (this.resultTransformer != null) {
                this.criteria.setResultTransformer(this.resultTransformer);
            }
            if (!this.uniqueResult) {
                if (this.scroll) {
                    result = this.criteria.scroll();
                } else if (this.count) {
                    this.criteria.setProjection(Projections.rowCount());
                    result = this.criteria.uniqueResult();
                } else if (this.paginationEnabledList) {
                    this.criteria.setFirstResult(0);
                    this.criteria.setMaxResults(Integer.MAX_VALUE);
                    boolean isProjection = this.projectionList != null && this.projectionList.getLength() > 0;
                    this.criteria.setProjection((Projection)(isProjection ? this.projectionList : null));
                    for (Order orderEntry : this.orderEntries) {
                        this.criteria.addOrder(orderEntry);
                    }
                    if (this.resultTransformer == null) {
                        this.criteria.setResultTransformer(isProjection ? CriteriaSpecification.PROJECTION : CriteriaSpecification.ROOT_ENTITY);
                    } else if (this.paginationEnabledList) {
                        this.criteria.setResultTransformer(this.resultTransformer);
                    }
                    HashMap argMap = (HashMap)args[0];
                    String sort = (String)argMap.get("sort");
                    if (sort != null) {
                        String associationForOrdering;
                        String orderParam;
                        boolean ignoreCase = true;
                        Object caseArg = argMap.get("ignoreCase");
                        if (caseArg instanceof Boolean) {
                            ignoreCase = (Boolean)caseArg;
                        }
                        String order = ORDER_DESCENDING.equalsIgnoreCase(orderParam = (String)argMap.get("order")) ? ORDER_DESCENDING : ORDER_ASCENDING;
                        int lastPropertyPos = sort.lastIndexOf(46);
                        String string = associationForOrdering = lastPropertyPos >= 0 ? sort.substring(0, lastPropertyPos) : null;
                        if (associationForOrdering != null && this.aliasMap.containsKey(associationForOrdering)) {
                            HibernateCriteriaBuilder.addOrder(this.criteria, this.aliasMap.get(associationForOrdering) + "." + sort.substring(lastPropertyPos + 1), order, ignoreCase);
                            HashMap argMap2 = new HashMap(argMap);
                            argMap2.remove("sort");
                            argMap = argMap2;
                        }
                    }
                    GrailsHibernateUtil.populateArgumentsForCriteria(this.grailsApplication, this.targetClass, this.criteria, argMap);
                    GrailsHibernateTemplate ght = new GrailsHibernateTemplate(this.sessionFactory, this.grailsApplication);
                    PagedResultList pagedRes = new PagedResultList(ght, this.criteria);
                    result = pagedRes;
                } else {
                    result = this.criteria.list();
                }
            } else {
                result = GrailsHibernateUtil.unwrapIfProxy(this.criteria.uniqueResult());
            }
            if (!this.participate) {
                this.hibernateSession.close();
            }
            return result;
        }
        if (this.criteria == null) {
            this.createCriteriaInstance();
        }
        if ((metaMethod = this.getMetaClass().getMetaMethod(name, args)) != null) {
            return metaMethod.invoke((Object)this, args);
        }
        metaMethod = this.criteriaMetaClass.getMetaMethod(name, args);
        if (metaMethod != null) {
            return metaMethod.invoke((Object)this.criteria, args);
        }
        metaMethod = this.criteriaMetaClass.getMetaMethod(GrailsClassUtils.getSetterName((String)name), args);
        if (metaMethod != null) {
            return metaMethod.invoke((Object)this.criteria, args);
        }
        if (this.isAssociationQueryMethod(args) || this.isAssociationQueryWithJoinSpecificationMethod(args)) {
            int joinType;
            boolean hasMoreThanOneArg = args.length > 1;
            Object callable = hasMoreThanOneArg ? args[1] : args[0];
            int n = joinType = hasMoreThanOneArg ? (Integer)args[0] : 0;
            if (name.equals(AND) || name.equals(OR) || name.equals(NOT)) {
                if (this.criteria == null) {
                    this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] not supported here"));
                }
                this.logicalExpressionStack.add(new LogicalExpression(name));
                this.invokeClosureNode(callable);
                LogicalExpression logicalExpression = this.logicalExpressionStack.remove(this.logicalExpressionStack.size() - 1);
                this.addToCriteria(logicalExpression.toCriterion());
                return name;
            }
            if (name.equals(PROJECTIONS) && args.length == 1 && args[0] instanceof Closure) {
                if (this.criteria == null) {
                    this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] not supported here"));
                }
                this.projectionList = Projections.projectionList();
                this.invokeClosureNode(callable);
                if (this.projectionList != null && this.projectionList.getLength() > 0) {
                    this.criteria.setProjection((Projection)this.projectionList);
                }
                return name;
            }
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(this.targetClass, (String)name);
            if (pd != null && pd.getReadMethod() != null) {
                ClassMetadata meta = this.sessionFactory.getClassMetadata(this.targetClass);
                Type type = meta.getPropertyType(name);
                if (type.isAssociationType()) {
                    String otherSideEntityName = ((AssociationType)type).getAssociatedEntityName((SessionFactoryImplementor)this.sessionFactory);
                    Class<?> oldTargetClass = this.targetClass;
                    this.targetClass = this.sessionFactory.getClassMetadata(otherSideEntityName).getMappedClass(EntityMode.POJO);
                    if (this.targetClass.equals(oldTargetClass) && !hasMoreThanOneArg) {
                        joinType = 1;
                    }
                    this.associationStack.add(name);
                    String associationPath = this.getAssociationPath();
                    this.createAliasIfNeccessary(name, associationPath, joinType);
                    this.logicalExpressionStack.add(new LogicalExpression(AND));
                    this.invokeClosureNode(callable);
                    this.aliasStack.remove(this.aliasStack.size() - 1);
                    if (!this.aliasInstanceStack.isEmpty()) {
                        this.aliasInstanceStack.remove(this.aliasInstanceStack.size() - 1);
                    }
                    LogicalExpression logicalExpression = this.logicalExpressionStack.remove(this.logicalExpressionStack.size() - 1);
                    if (!logicalExpression.args.isEmpty()) {
                        this.addToCriteria(logicalExpression.toCriterion());
                    }
                    this.associationStack.remove(this.associationStack.size() - 1);
                    this.targetClass = oldTargetClass;
                    return name;
                }
                if (type instanceof EmbeddedComponentType) {
                    this.associationStack.add(name);
                    this.logicalExpressionStack.add(new LogicalExpression(AND));
                    Class<?> oldTargetClass = this.targetClass;
                    this.targetClass = pd.getPropertyType();
                    this.invokeClosureNode(callable);
                    this.targetClass = oldTargetClass;
                    LogicalExpression logicalExpression = this.logicalExpressionStack.remove(this.logicalExpressionStack.size() - 1);
                    if (!logicalExpression.args.isEmpty()) {
                        this.addToCriteria(logicalExpression.toCriterion());
                    }
                    this.associationStack.remove(this.associationStack.size() - 1);
                    return name;
                }
            }
        } else if (args.length == 1 && args[0] != null) {
            if (this.criteria == null) {
                this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] not supported here"));
            }
            Object value = args[0];
            Criterion c = null;
            if (name.equals(ID_EQUALS)) {
                return this.eq("id", value);
            }
            if (name.equals(IS_NULL) || name.equals(IS_NOT_NULL) || name.equals(IS_EMPTY) || name.equals(IS_NOT_EMPTY)) {
                if (!(value instanceof String)) {
                    this.throwRuntimeException(new IllegalArgumentException("call to [" + name + "] with value [" + value + "] requires a String value."));
                }
                String propertyName = this.calculatePropertyName((String)value);
                if (name.equals(IS_NULL)) {
                    c = Restrictions.isNull((String)propertyName);
                } else if (name.equals(IS_NOT_NULL)) {
                    c = Restrictions.isNotNull((String)propertyName);
                } else if (name.equals(IS_EMPTY)) {
                    c = Restrictions.isEmpty((String)propertyName);
                } else if (name.equals(IS_NOT_EMPTY)) {
                    c = Restrictions.isNotEmpty((String)propertyName);
                }
            }
            if (c != null) {
                return this.addToCriteria(c);
            }
        }
        throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args);
    }

    private boolean isAssociationQueryMethod(Object[] args) {
        return args.length == 1 && args[0] instanceof Closure;
    }

    private boolean isAssociationQueryWithJoinSpecificationMethod(Object[] args) {
        return args.length == 2 && args[0] instanceof Number && args[1] instanceof Closure;
    }

    private void addToCurrentOrAliasedCriteria(Criterion criterion) {
        if (!this.aliasInstanceStack.isEmpty()) {
            Criteria c = this.aliasInstanceStack.get(this.aliasInstanceStack.size() - 1);
            c.add(criterion);
        } else {
            this.criteria.add(criterion);
        }
    }

    private void createAliasIfNeccessary(String associationName, String associationPath, int joinType) {
        String newAlias;
        if (this.aliasMap.containsKey(associationPath)) {
            newAlias = this.aliasMap.get(associationPath);
        } else {
            ++this.aliasCount;
            newAlias = associationName + ALIAS + this.aliasCount;
            this.aliasMap.put(associationPath, newAlias);
            this.aliasInstanceStack.add(this.criteria.createAlias(associationPath, newAlias, joinType));
        }
        this.aliasStack.add(newAlias);
    }

    private String getAssociationPath() {
        StringBuilder fullPath = new StringBuilder();
        Iterator<String> i$ = this.associationStack.iterator();
        while (i$.hasNext()) {
            String anAssociationStack;
            String propertyName = anAssociationStack = i$.next();
            if (fullPath.length() > 0) {
                fullPath.append(".");
            }
            fullPath.append(propertyName);
        }
        return fullPath.toString();
    }

    private boolean isCriteriaConstructionMethod(String name, Object[] args) {
        return name.equals(LIST_CALL) && args.length == 2 && args[0] instanceof Map && args[1] instanceof Closure || name.equals(ROOT_CALL) || name.equals(ROOT_DO_CALL) || name.equals(LIST_CALL) || name.equals(LIST_DISTINCT_CALL) || name.equals(GET_CALL) || name.equals(COUNT_CALL) || name.equals(SCROLL_CALL) && args.length == 1 && args[0] instanceof Closure;
    }

    public Criteria buildCriteria(Closure<?> criteriaClosure) {
        this.createCriteriaInstance();
        criteriaClosure.setDelegate((Object)this);
        criteriaClosure.call();
        return this.criteria;
    }

    private void createCriteriaInstance() {
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            this.participate = true;
            this.hibernateSession = ((SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory)).getSession();
        } else {
            this.hibernateSession = this.sessionFactory.openSession();
        }
        this.criteria = this.hibernateSession.createCriteria(this.targetClass);
        GrailsHibernateUtil.cacheCriteriaByMapping(this.grailsApplication, this.targetClass, this.criteria);
        this.criteriaMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.criteria.getClass());
    }

    private void invokeClosureNode(Object args) {
        Closure callable = (Closure)args;
        callable.setDelegate((Object)this);
        callable.setResolveStrategy(1);
        callable.call();
    }

    private void throwRuntimeException(RuntimeException t) {
        this.closeSessionFollowingException();
        throw t;
    }

    private void closeSessionFollowingException() {
        if (this.hibernateSession != null && this.hibernateSession.isOpen() && !this.participate) {
            this.hibernateSession.close();
        }
        this.criteria = null;
    }

    private Criterion addToCriteria(Criterion c) {
        if (!this.logicalExpressionStack.isEmpty()) {
            this.logicalExpressionStack.get((int)(this.logicalExpressionStack.size() - 1)).args.add(c);
        } else {
            this.criteria.add(c);
        }
        return c;
    }

    private static void addOrder(Criteria c, String sort, String order, boolean ignoreCase) {
        if (ORDER_DESCENDING.equals(order)) {
            c.addOrder(ignoreCase ? Order.desc((String)sort).ignoreCase() : Order.desc((String)sort));
        } else {
            c.addOrder(ignoreCase ? Order.asc((String)sort).ignoreCase() : Order.asc((String)sort));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogicalExpression {
        final Object name;
        final List<Criterion> args = new ArrayList<Criterion>();

        LogicalExpression(Object name) {
            this.name = name;
        }

        Criterion toCriterion() {
            if (this.name.equals(HibernateCriteriaBuilder.NOT)) {
                switch (this.args.size()) {
                    case 0: {
                        HibernateCriteriaBuilder.this.throwRuntimeException(new IllegalArgumentException("Logical expression [not] must contain at least 1 expression"));
                        return null;
                    }
                    case 1: {
                        return Restrictions.not((Criterion)this.args.get(0));
                    }
                }
                return Restrictions.not((Criterion)this.buildJunction((Junction)Restrictions.disjunction(), this.args));
            }
            if (this.name.equals(HibernateCriteriaBuilder.AND)) {
                return this.buildJunction((Junction)Restrictions.conjunction(), this.args);
            }
            if (this.name.equals(HibernateCriteriaBuilder.OR)) {
                return this.buildJunction((Junction)Restrictions.disjunction(), this.args);
            }
            HibernateCriteriaBuilder.this.throwRuntimeException(new IllegalStateException("Logical expression [" + this.name + "] not handled!"));
            return null;
        }

        Junction buildJunction(Junction junction, List<Criterion> criterions) {
            for (Criterion c : criterions) {
                junction.add(c);
            }
            return junction;
        }
    }
}

