/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.exceptions.GrailsRuntimeException;
import org.codehaus.groovy.grails.lifecycle.ShutdownOperations;
import org.codehaus.groovy.grails.orm.hibernate.validation.AbstractPersistentConstraint;
import org.codehaus.groovy.grails.orm.hibernate.validation.PersistentConstraintFactory;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueConstraint
extends AbstractPersistentConstraint {
    private static final String DEFAULT_NOT_UNIQUE_MESSAGE_CODE = "default.not.unique.message";
    public static final String UNIQUE_CONSTRAINT = "unique";
    private boolean unique;
    private List<String> uniquenessGroup = new ArrayList<String>();

    public UniqueConstraint() {
        ShutdownOperations.addOperation((Runnable)new Runnable(){

            public void run() {
                ConstrainedProperty.removeConstraint((String)UniqueConstraint.UNIQUE_CONSTRAINT, PersistentConstraintFactory.class);
            }
        });
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isUniqueWithinGroup() {
        return !this.uniquenessGroup.isEmpty();
    }

    public void setParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Boolean || constraintParameter instanceof String || constraintParameter instanceof CharSequence || constraintParameter instanceof List)) {
            throw new IllegalArgumentException("Parameter for constraint [unique] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean or string value");
        }
        if (constraintParameter instanceof List) {
            for (Object e : (List)constraintParameter) {
                if (!(e instanceof String) && !(e instanceof CharSequence)) {
                    throw new IllegalArgumentException("Parameter for constraint [unique] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a boolean or string value");
                }
                this.uniquenessGroup.add(e.toString());
            }
        } else if (constraintParameter instanceof String || constraintParameter instanceof CharSequence) {
            this.uniquenessGroup.add(constraintParameter.toString());
            this.unique = true;
        } else {
            this.unique = (Boolean)constraintParameter;
        }
        if (!this.uniquenessGroup.isEmpty()) {
            this.unique = true;
            for (Object object : this.uniquenessGroup) {
                String propertyName = (String)object;
                if (GrailsClassUtils.getPropertyType((Class)this.constraintOwningClass, (String)propertyName) != null) continue;
                throw new IllegalArgumentException("Scope for constraint [unique] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a valid property name of same class");
            }
        }
        super.setParameter(constraintParameter);
    }

    public String getName() {
        return UNIQUE_CONSTRAINT;
    }

    protected void processValidate(final Object target, final Object propertyValue, Errors errors) {
        Object id;
        if (!this.unique) {
            return;
        }
        try {
            id = InvokerHelper.invokeMethod((Object)target, (String)"ident", null);
        }
        catch (Exception e) {
            throw new GrailsRuntimeException("Target of [unique] constraints [" + target + "] is not a domain instance. Unique constraint can only be applied to " + "domain classes and not custom user types or embedded instances");
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        Assert.state((hibernateTemplate != null ? 1 : 0) != 0, (String)"Unable use [unique] constraint, no Hibernate SessionFactory found!");
        List results = hibernateTemplate.executeFind(new HibernateCallback<List<?>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<?> doInHibernate(Session session) throws HibernateException {
                session.setFlushMode(FlushMode.MANUAL);
                try {
                    boolean shouldValidate = true;
                    Class constraintClass = UniqueConstraint.this.constraintOwningClass;
                    if (propertyValue != null && DomainClassArtefactHandler.isDomainClass(propertyValue.getClass())) {
                        shouldValidate = session.contains(propertyValue);
                    }
                    if (shouldValidate) {
                        List list;
                        GrailsApplication application = (GrailsApplication)UniqueConstraint.this.applicationContext.getBean("grailsApplication");
                        GrailsDomainClass domainClass = (GrailsDomainClass)application.getArtefact("Domain", constraintClass.getName());
                        if (domainClass != null && !domainClass.isRoot()) {
                            GrailsDomainClassProperty property = domainClass.getPropertyByName(UniqueConstraint.this.constraintPropertyName);
                            while (property.isInherited() && domainClass != null) {
                                if ((domainClass = (GrailsDomainClass)application.getArtefact("Domain", domainClass.getClazz().getSuperclass().getName())) == null) continue;
                                property = domainClass.getPropertyByName(UniqueConstraint.this.constraintPropertyName);
                            }
                            constraintClass = domainClass != null ? domainClass.getClazz() : constraintClass;
                        }
                        Criteria criteria = session.createCriteria(constraintClass).add((Criterion)Restrictions.eq((String)UniqueConstraint.this.constraintPropertyName, (Object)propertyValue));
                        if (UniqueConstraint.this.uniquenessGroup != null) {
                            for (Object anUniquenessGroup : UniqueConstraint.this.uniquenessGroup) {
                                String uniquenessGroupPropertyName = (String)anUniquenessGroup;
                                Object uniquenessGroupPropertyValue = GrailsClassUtils.getPropertyOrStaticPropertyOrFieldValue((Object)target, (String)uniquenessGroupPropertyName);
                                if (uniquenessGroupPropertyValue != null && DomainClassArtefactHandler.isDomainClass(uniquenessGroupPropertyValue.getClass())) {
                                    try {
                                        session.lock(uniquenessGroupPropertyValue, LockMode.NONE);
                                    }
                                    catch (TransientObjectException e) {
                                        shouldValidate = false;
                                    }
                                }
                                if (!shouldValidate) break;
                                criteria.add((Criterion)Restrictions.eq((String)uniquenessGroupPropertyName, (Object)uniquenessGroupPropertyValue));
                            }
                        }
                        if (shouldValidate) {
                            list = criteria.list();
                            return list;
                        }
                        list = Collections.EMPTY_LIST;
                        return list;
                    }
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                finally {
                    session.setFlushMode(FlushMode.AUTO);
                }
            }
        });
        if (results.isEmpty()) {
            return;
        }
        boolean reject = false;
        if (id != null) {
            Object existing = results.get(0);
            Object existingId = null;
            try {
                existingId = InvokerHelper.invokeMethod(existing, (String)"ident", null);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!id.equals(existingId)) {
                reject = true;
            }
        } else {
            reject = true;
        }
        if (reject) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue};
            this.rejectValue(target, errors, UNIQUE_CONSTRAINT, args, this.getDefaultMessage(DEFAULT_NOT_UNIQUE_MESSAGE_CODE));
        }
    }

    public List<String> getUniquenessGroup() {
        return this.uniquenessGroup;
    }
}

