/*
 * Decompiled with CFR 0.152.
 */
package org.grails.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.grails.launcher.GrailsLauncher;
import org.grails.launcher.RootLoader;

public class ForkedGrailsLauncher {
    private ExecutionContext executionContext;
    private int maxMemory = 1024;
    private int minMemory = 512;
    private int maxPerm = 256;
    private boolean debug;

    public ForkedGrailsLauncher(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public void setMaxMemory(int n) {
        this.maxMemory = n;
    }

    public void setMinMemory(int n) {
        this.minMemory = n;
    }

    public void setMaxPerm(int n) {
        this.maxPerm = n;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void fork() {
        File file2;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        StringBuilder stringBuilder = new StringBuilder();
        for (File file2 : this.executionContext.getBuildDependencies()) {
            stringBuilder.append(file2).append(File.pathSeparator);
        }
        Object object = null;
        file2 = null;
        try {
            String string = this.executionContext.getBaseDir().getCanonicalFile().getName();
            file2 = File.createTempFile(string, "grails-execution-context");
            file2.deleteOnExit();
            object = new FileOutputStream(file2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
            objectOutputStream.writeObject(this.executionContext);
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("java", "-Xmx" + this.maxMemory + "M", "-Xms" + this.minMemory + "M", "-XX:MaxPermSize=" + this.maxPerm + "m", "-Dgrails.build.execution.context=" + file2.getCanonicalPath(), "-cp", stringBuilder.toString()));
            if (this.debug) {
                arrayList.addAll(Arrays.asList("-Xdebug", "-Xnoagent", "-Dgrails.full.stacktrace=true", "-Djava.compiler=NONE", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005"));
            }
            arrayList.add(this.getClass().getName());
            processBuilder.directory(this.executionContext.baseDir).redirectErrorStream(true).command(arrayList);
            Process process = processBuilder.start();
            new Thread(new TextDumper(process.getInputStream(), System.out)).start();
            new Thread(new TextDumper(process.getErrorStream(), System.err)).start();
            int n = process.waitFor();
            if (n == 1) {
                throw new RuntimeException("Forked Grails VM exited with error");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Fatal error forking Grails JVM: " + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Fatal error forking Grails JVM: " + iOException.getMessage(), iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Fatal error forking Grails JVM: " + interruptedException.getMessage(), interruptedException);
        }
        finally {
            if (object != null) {
                try {
                    ((FileOutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = System.getProperty("grails.build.execution.context");
        if (string != null) {
            File file = new File(string);
            FileInputStream fileInputStream = null;
            try {
                Class<?> clazz;
                fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                ExecutionContext executionContext = (ExecutionContext)objectInputStream.readObject();
                URL[] uRLArray = ForkedGrailsLauncher.generateBuildPath(executionContext.getBuildDependencies());
                RootLoader rootLoader = new RootLoader(uRLArray, ClassLoader.getSystemClassLoader());
                System.setProperty("grails.console.enable.terminal", "false");
                System.setProperty("grails.console.enable.interactive", "false");
                ArrayList<File> arrayList = new ArrayList<File>();
                for (File file2 : executionContext.getCompileDependencies()) {
                    String string2 = file2.getName();
                    if (!string2.contains("slf4j") && !string2.contains("log4j") && !string2.contains("spring-core")) continue;
                    arrayList.add(file2);
                }
                if (!arrayList.isEmpty()) {
                    for (File file2 : arrayList) {
                        rootLoader.addURL(file2.toURI().toURL());
                    }
                    clazz = rootLoader.loadClass("org.springframework.util.Log4jConfigurer");
                    ForkedGrailsLauncher.invokeStaticMethod(clazz, "initLogging", new Object[]{"classpath:grails-maven/log4j.properties"});
                }
                clazz = new GrailsLauncher(rootLoader, null, executionContext.getBaseDir().getAbsolutePath());
                ((GrailsLauncher)((Object)clazz)).setPlainOutput(true);
                ((GrailsLauncher)((Object)clazz)).setDependenciesExternallyConfigured(true);
                ((GrailsLauncher)((Object)clazz)).setProvidedDependencies(executionContext.getProvidedDependencies());
                ((GrailsLauncher)((Object)clazz)).setCompileDependencies(executionContext.getCompileDependencies());
                ((GrailsLauncher)((Object)clazz)).setTestDependencies(executionContext.getTestDependencies());
                ((GrailsLauncher)((Object)clazz)).setRuntimeDependencies(executionContext.getRuntimeDependencies());
                ((GrailsLauncher)((Object)clazz)).setGrailsWorkDir(executionContext.getGrailsWorkDir());
                ((GrailsLauncher)((Object)clazz)).setProjectWorkDir(executionContext.getProjectWorkDir());
                ((GrailsLauncher)((Object)clazz)).setClassesDir(executionContext.getClassesDir());
                ((GrailsLauncher)((Object)clazz)).setTestClassesDir(executionContext.getTestClassesDir());
                ((GrailsLauncher)((Object)clazz)).setResourcesDir(executionContext.getResourcesDir());
                ((GrailsLauncher)((Object)clazz)).setProjectPluginsDir(executionContext.getProjectPluginsDir());
                ((GrailsLauncher)((Object)clazz)).setBuildDependencies(executionContext.getBuildDependencies());
                System.exit(((GrailsLauncher)((Object)clazz)).launch(executionContext.getScriptName(), executionContext.getArgs(), executionContext.getEnv()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                ForkedGrailsLauncher.fatalError(fileNotFoundException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ForkedGrailsLauncher.fatalError(classNotFoundException);
            }
            catch (IOException iOException) {
                ForkedGrailsLauncher.fatalError(iOException);
            }
            catch (Throwable throwable) {
                ForkedGrailsLauncher.fatalError(throwable);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            System.exit(1);
        }
    }

    protected static void fatalError(Throwable throwable) {
        System.err.println("Fatal error forking Grails JVM: " + throwable.getMessage());
        throwable.printStackTrace(System.err);
        System.exit(1);
    }

    private static URL[] generateBuildPath(List<File> list) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file : list) {
            try {
                arrayList.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    private static Object invokeStaticMethod(Class clazz, String string, Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        try {
            return clazz.getMethod(string, classArray).invoke((Object)clazz, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static class TextDumper
    implements Runnable {
        InputStream in;
        Appendable app;

        public TextDumper(InputStream inputStream, Appendable appendable) {
            this.in = inputStream;
            this.app = appendable;
        }

        @Override
        public void run() {
            InputStreamReader inputStreamReader = new InputStreamReader(this.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (this.app == null) continue;
                    this.app.append(string);
                    this.app.append("\n");
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("exception while reading process stream", iOException);
            }
        }
    }

    public static class ExecutionContext
    implements Serializable {
        private List<File> compileDependencies;
        private List<File> runtimeDependencies;
        private List<File> buildDependencies;
        private List<File> providedDependencies;
        private List<File> testDependencies;
        private File grailsWorkDir;
        private File projectWorkDir;
        private File classesDir;
        private File testClassesDir;
        private File resourcesDir;
        private File projectPluginsDir;
        private File baseDir;
        private String scriptName;
        private String env;
        private String args;

        public String getScriptName() {
            return this.scriptName;
        }

        public void setScriptName(String string) {
            this.scriptName = string;
        }

        public String getEnv() {
            return this.env;
        }

        public void setEnv(String string) {
            this.env = string;
        }

        public String getArgs() {
            return this.args;
        }

        public void setArgs(String string) {
            this.args = string;
        }

        public File getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(File file) {
            this.baseDir = file;
        }

        public List<File> getCompileDependencies() {
            return this.compileDependencies;
        }

        public void setCompileDependencies(List<File> list) {
            this.compileDependencies = list;
        }

        public List<File> getRuntimeDependencies() {
            return this.runtimeDependencies;
        }

        public void setRuntimeDependencies(List<File> list) {
            this.runtimeDependencies = list;
        }

        public List<File> getBuildDependencies() {
            return this.buildDependencies;
        }

        public void setBuildDependencies(List<File> list) {
            this.buildDependencies = list;
        }

        public List<File> getProvidedDependencies() {
            return this.providedDependencies;
        }

        public void setProvidedDependencies(List<File> list) {
            this.providedDependencies = list;
        }

        public List<File> getTestDependencies() {
            return this.testDependencies;
        }

        public void setTestDependencies(List<File> list) {
            this.testDependencies = list;
        }

        public File getGrailsWorkDir() {
            return this.grailsWorkDir;
        }

        public void setGrailsWorkDir(File file) {
            this.grailsWorkDir = file;
        }

        public File getProjectWorkDir() {
            return this.projectWorkDir;
        }

        public void setProjectWorkDir(File file) {
            this.projectWorkDir = file;
        }

        public File getClassesDir() {
            return this.classesDir;
        }

        public void setClassesDir(File file) {
            this.classesDir = file;
        }

        public File getTestClassesDir() {
            return this.testClassesDir;
        }

        public void setTestClassesDir(File file) {
            this.testClassesDir = file;
        }

        public File getResourcesDir() {
            return this.resourcesDir;
        }

        public void setResourcesDir(File file) {
            this.resourcesDir = file;
        }

        public File getProjectPluginsDir() {
            return this.projectPluginsDir;
        }

        public void setProjectPluginsDir(File file) {
            this.projectPluginsDir = file;
        }
    }
}

