/*
 * Decompiled with CFR 0.152.
 */
package org.grails.launcher;

class GrailsVersion {
    protected final String string;
    protected final int major;
    protected final int minor;
    protected final int patch;
    protected final String tag;

    public GrailsVersion(String string) {
        this.string = string;
        Object var2_2 = null;
        String[] stringArray = string.split("\\.", 4);
        int n = this.major = stringArray.length > 0 ? this.asInt(stringArray[0]) : 0;
        if (this.containsTag(stringArray[1])) {
            String[] stringArray2 = stringArray[1].split("-", 2);
            this.minor = this.asInt(stringArray2[0]);
            this.patch = 0;
            this.tag = stringArray2[1];
        } else if (this.isTag(stringArray[1])) {
            this.minor = 0;
            this.patch = 0;
            this.tag = stringArray[1];
        } else {
            this.minor = this.asInt(stringArray[1]);
            if (stringArray.length > 2) {
                if (this.containsTag(stringArray[2])) {
                    String[] stringArray3 = stringArray[2].split("-", 2);
                    this.patch = this.asInt(stringArray3[0]);
                    this.tag = stringArray3[1];
                } else if (this.isTag(stringArray[2])) {
                    this.patch = 0;
                    this.tag = stringArray[2];
                } else {
                    this.patch = this.asInt(stringArray[2]);
                    this.tag = stringArray.length > 3 ? stringArray[3] : null;
                }
            } else {
                this.patch = 0;
                this.tag = null;
            }
        }
    }

    public String getString() {
        return this.string;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getTag() {
        return this.tag;
    }

    private int asInt(String string) throws NumberFormatException {
        return this.asInteger(string);
    }

    private Integer asInteger(String string) throws NumberFormatException {
        return Integer.valueOf(string);
    }

    private boolean isInteger(String string) {
        try {
            this.asInteger(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isTag(String string) {
        return !string.matches("\\d+");
    }

    private boolean containsTag(String string) {
        return string.matches("\\d+-.*");
    }

    public boolean is(int n) {
        return this.major == n;
    }

    public boolean is(int n, int n2) {
        return this.major == n && this.minor == n2;
    }

    public boolean is(int n, int n2, int n3) {
        return this.major == n && this.minor == n2 && this.patch == n3;
    }

    public boolean is13() {
        return this.is(1, 3);
    }

    public boolean isRequiresExplicitIvyDependency() {
        return this.is13() && this.patch < 2;
    }
}

