/*
 * Decompiled with CFR 0.152.
 */
package org.grails.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.grails.launcher.GrailsLauncher;
import org.grails.launcher.context.GrailsLaunchContext;

public class ForkedGrailsLauncher
implements GrailsLauncher {
    private int maxMemory = 1024;
    private int minMemory = 512;
    private int maxPerm = 256;
    private boolean debug;

    public void setMaxMemory(int maxMemory) {
        this.maxMemory = maxMemory;
    }

    public void setMinMemory(int minMemory) {
        this.minMemory = minMemory;
    }

    public void setMaxPerm(int maxPerm) {
        this.maxPerm = maxPerm;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public int launch(GrailsLaunchContext launchContext) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        StringBuilder cp = new StringBuilder();
        for (File file : launchContext.getBuildDependencies()) {
            cp.append(file).append(File.pathSeparator);
        }
        FileOutputStream fos = null;
        try {
            String baseName = launchContext.getBaseDir().getCanonicalFile().getName();
            File tempFile = File.createTempFile(baseName, "grails-execution-context");
            tempFile.deleteOnExit();
            fos = new FileOutputStream(tempFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(launchContext);
            ArrayList<String> cmd = new ArrayList<String>(Arrays.asList("java", "-Xmx" + this.maxMemory + "M", "-Xms" + this.minMemory + "M", "-XX:MaxPermSize=" + this.maxPerm + "m", "-cp", cp.toString()));
            if (this.debug) {
                cmd.addAll(Arrays.asList("-Xdebug", "-Xnoagent", "-Dgrails.full.stacktrace=true", "-Djava.compiler=NONE", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005"));
            }
            cmd.add(this.getClass().getName());
            cmd.add(tempFile.getCanonicalPath());
            processBuilder.directory(launchContext.getBaseDir()).redirectErrorStream(true).command(cmd);
            Process process = processBuilder.start();
            new Thread(new TextDumper(process.getInputStream(), System.out)).start();
            new Thread(new TextDumper(process.getErrorStream(), System.err)).start();
            int n = process.waitFor();
            return n;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Fatal error forking Grails JVM: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Fatal error forking Grails JVM: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Fatal error forking Grails JVM: " + e.getMessage(), e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class TextDumper
    implements Runnable {
        InputStream in;
        Appendable app;

        public TextDumper(InputStream in, Appendable app) {
            this.in = in;
            this.app = app;
        }

        @Override
        public void run() {
            InputStreamReader isr = new InputStreamReader(this.in);
            BufferedReader br = new BufferedReader(isr);
            try {
                String next;
                while ((next = br.readLine()) != null) {
                    if (this.app == null) continue;
                    this.app.append(next);
                    this.app.append("\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("exception while reading process stream", e);
            }
        }
    }
}

