/*
 * Decompiled with CFR 0.152.
 */
package org.grails.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.grails.launcher.InProcessGrailsLauncher;
import org.grails.launcher.context.GrailsLaunchContext;

public class Main {
    private final String location;

    public Main(String location) {
        this.location = location;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Expecting one argument; the location of a serialized " + GrailsLaunchContext.class.getName());
            System.exit(1);
        }
        try {
            System.exit(new Main(args[0]).run());
        }
        catch (Exception e) {
            System.err.println("Fatal error forking Grails JVM: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws Exception {
        GrailsLaunchContext launchContext;
        File serialisedContextFile = new File(this.location);
        FileInputStream fileInputStream = new FileInputStream(serialisedContextFile);
        try {
            launchContext = this.hydrate(fileInputStream);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException ignore) {}
        }
        InProcessGrailsLauncher grailsLauncher = new InProcessGrailsLauncher();
        return grailsLauncher.launch(launchContext);
    }

    private GrailsLaunchContext hydrate(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return (GrailsLaunchContext)objectInputStream.readObject();
    }
}

