/*
 * Decompiled with CFR 0.152.
 */
package org.grails.launcher.context;

import java.io.File;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.grails.launcher.context.GrailsLaunchContext;
import org.grails.launcher.util.ReflectionUtils;
import org.grails.launcher.version.GrailsVersion;
import org.grails.launcher.version.GrailsVersionQuirks;

public class DelegatingGrailsLaunchContext
implements GrailsLaunchContext {
    private static final String PROJECT_COMPILE_CLASS = "org.codehaus.groovy.grails.compiler.GrailsProjectCompiler";
    private static final String PLUGIN_BUILD_SETTINGS_CLASS = "grails.util.PluginBuildSettings";
    private ClassLoader classLoader;
    private Object settings;
    private final GrailsVersion grailsVersion;
    private final GrailsVersionQuirks grailsVersionQuirks;
    private String scriptName;
    private String env;
    private String args;
    private List<File> buildDependencies;

    public static DelegatingGrailsLaunchContext copyOf(ClassLoader classLoader, GrailsLaunchContext source) {
        DelegatingGrailsLaunchContext context = new DelegatingGrailsLaunchContext(source.getGrailsVersion(), classLoader, source.getGrailsHome(), source.getBaseDir());
        context.setDependenciesExternallyConfigured(source.isDependenciesExternallyConfigured());
        context.setPlainOutput(source.isPlainOutput());
        if (source.getScriptName() != null) {
            context.setScriptName(source.getScriptName());
        }
        if (source.getArgs() != null) {
            context.setArgs(source.getArgs());
        }
        if (source.getEnv() != null) {
            context.setEnv(source.getEnv());
        }
        if (source.getBuildDependencies() != null) {
            context.setBuildDependencies(source.getBuildDependencies());
        }
        if (context.grailsVersionQuirks.isSupportsProvidedDependencies()) {
            if (source.getProvidedDependencies() != null) {
                context.setProvidedDependencies((List)source.getProvidedDependencies());
            }
            if (source.getCompileDependencies() != null) {
                context.setCompileDependencies((List)source.getCompileDependencies());
            }
        } else {
            List<File> compile;
            LinkedList<File> providedAndCompileDependencies = new LinkedList<File>();
            boolean hasAny = false;
            List<File> provided = source.getProvidedDependencies();
            if (provided != null) {
                providedAndCompileDependencies.addAll(provided);
                hasAny = true;
            }
            if ((compile = source.getCompileDependencies()) != null) {
                providedAndCompileDependencies.addAll(compile);
                hasAny = true;
            }
            if (hasAny) {
                context.setCompileDependencies(providedAndCompileDependencies);
            }
        }
        if (source.getRuntimeDependencies() != null) {
            context.setRuntimeDependencies((List)source.getRuntimeDependencies());
        }
        if (source.getTestDependencies() != null) {
            context.setTestDependencies((List)source.getTestDependencies());
        }
        if (source.getGrailsWorkDir() != null) {
            context.setGrailsWorkDir(source.getGrailsWorkDir());
        }
        if (source.getProjectWorkDir() != null) {
            context.setProjectWorkDir(source.getProjectWorkDir());
        }
        if (source.getClassesDir() != null) {
            context.setClassesDir(source.getClassesDir());
        }
        if (source.getTestClassesDir() != null) {
            context.setTestClassesDir(source.getTestClassesDir());
        }
        if (source.getTestReportsDir() != null) {
            context.setTestReportsDir(source.getTestReportsDir());
        }
        if (source.getResourcesDir() != null) {
            context.setResourcesDir(source.getResourcesDir());
        }
        if (source.getProjectPluginsDir() != null) {
            context.setProjectPluginsDir(source.getProjectPluginsDir());
        }
        if (source.getGlobalPluginsDir() != null) {
            context.setGlobalPluginsDir(source.getGlobalPluginsDir());
        }
        return context;
    }

    public DelegatingGrailsLaunchContext(GrailsVersion grailsVersion, ClassLoader classLoader, File grailsHome, File baseDir) {
        this.grailsVersion = grailsVersion;
        this.grailsVersionQuirks = new GrailsVersionQuirks(grailsVersion);
        this.classLoader = classLoader;
        try {
            this.classLoader = classLoader;
            Class<?> clazz = classLoader.loadClass("grails.util.BuildSettings");
            this.settings = clazz.getConstructor(File.class, File.class).newInstance(grailsHome, baseDir);
            ReflectionUtils.invokeMethod(this.settings, "setRootLoader", new Class[]{URLClassLoader.class}, new Object[]{classLoader});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public GrailsVersion getGrailsVersion() {
        return this.grailsVersion;
    }

    @Override
    public File getGrailsHome() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getGrailsHome");
    }

    @Override
    public void setGrailsHome(File grailsHome) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setGrailsHome", new Class[]{File.class}, new Object[]{grailsHome});
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    @Override
    public String getEnv() {
        return this.env;
    }

    @Override
    public void setEnv(String env) {
        this.env = env;
    }

    @Override
    public String getArgs() {
        return this.args;
    }

    @Override
    public void setArgs(String args) {
        this.args = args;
    }

    @Override
    public File getGrailsWorkDir() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getGrailsWorkDir", new Object[0]);
    }

    @Override
    public void setGrailsWorkDir(File dir) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setGrailsWorkDir", new Class[]{File.class}, new Object[]{dir});
    }

    @Override
    public File getProjectWorkDir() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getProjectWorkDir", new Object[0]);
    }

    @Override
    public void setProjectWorkDir(File dir) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setProjectWorkDir", new Class[]{File.class}, new Object[]{dir});
    }

    @Override
    public File getClassesDir() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getClassesDir", new Object[0]);
    }

    @Override
    public void setClassesDir(File dir) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setClassesDir", new Class[]{File.class}, new Object[]{dir});
    }

    @Override
    public File getTestClassesDir() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getTestClassesDir", new Object[0]);
    }

    @Override
    public void setTestClassesDir(File dir) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setTestClassesDir", new Class[]{File.class}, new Object[]{dir});
    }

    @Override
    public File getResourcesDir() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getResourcesDir", new Object[0]);
    }

    @Override
    public void setResourcesDir(File dir) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setResourcesDir", new Class[]{File.class}, new Object[]{dir});
    }

    @Override
    public File getProjectPluginsDir() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getProjectPluginsDir", new Object[0]);
    }

    @Override
    public void setProjectPluginsDir(File dir) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setProjectPluginsDir", new Class[]{File.class}, new Object[]{dir});
    }

    @Override
    public File getGlobalPluginsDir() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getGlobalPluginsDir", new Object[0]);
    }

    @Override
    public void setGlobalPluginsDir(File dir) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setGlobalPluginsDir", new Class[]{File.class}, new Object[]{dir});
    }

    @Override
    public File getTestReportsDir() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getTestReportsDir", new Object[0]);
    }

    @Override
    public void setTestReportsDir(File dir) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setTestReportsDir", new Class[]{File.class}, new Object[]{dir});
    }

    public List getCompileDependencies() {
        return (List)ReflectionUtils.invokeMethodWrapException(this.settings, "getCompileDependencies", new Object[0]);
    }

    public void setCompileDependencies(List dependencies) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setCompileDependencies", new Class[]{List.class}, new Object[]{dependencies});
    }

    @Override
    public void setDependenciesExternallyConfigured(boolean b) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setDependenciesExternallyConfigured", new Class[]{Boolean.TYPE}, new Object[]{b});
    }

    @Override
    public boolean isDependenciesExternallyConfigured() {
        return (Boolean)ReflectionUtils.invokeMethodWrapException(this.settings, "isDependenciesExternallyConfigured");
    }

    public List getTestDependencies() {
        return (List)ReflectionUtils.invokeMethodWrapException(this.settings, "getTestDependencies", new Object[0]);
    }

    public void setTestDependencies(List dependencies) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setTestDependencies", new Class[]{List.class}, new Object[]{dependencies});
    }

    public List getProvidedDependencies() {
        return (List)ReflectionUtils.invokeMethodWrapException(this.settings, "getProvidedDependencies");
    }

    public void setProvidedDependencies(List dependencies) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setProvidedDependencies", new Class[]{List.class}, new Object[]{dependencies});
    }

    @Override
    public void setBuildDependencies(List<File> dependencies) {
        if (this.grailsVersionQuirks.isSupportsBuildDependencies()) {
            ReflectionUtils.invokeMethodWrapException(this.settings, "setBuildDependencies", new Class[]{List.class}, new Object[]{dependencies});
        } else {
            this.buildDependencies = dependencies;
        }
    }

    public List getBuildDependencies() {
        if (this.grailsVersionQuirks.isSupportsBuildDependencies()) {
            return (List)ReflectionUtils.invokeMethodWrapException(this.settings, "getBuildDependencies", new Object[0]);
        }
        return this.buildDependencies;
    }

    public List getRuntimeDependencies() {
        return (List)ReflectionUtils.invokeMethodWrapException(this.settings, "getRuntimeDependencies", new Object[0]);
    }

    public void setRuntimeDependencies(List dependencies) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setRuntimeDependencies", new Class[]{List.class}, new Object[]{dependencies});
    }

    @Override
    public File getBaseDir() {
        return (File)ReflectionUtils.invokeMethodWrapException(this.settings, "getBaseDir", new Object[0]);
    }

    @Override
    public void setBaseDir(File baseDir) {
        ReflectionUtils.invokeMethodWrapException(this.settings, "setBaseDir", new Class[]{File.class}, new Object[]{baseDir});
    }

    @Override
    public boolean isPlainOutput() {
        try {
            Class<?> clazz = this.classLoader.loadClass("grails.build.logging.GrailsConsole");
            Object console = ReflectionUtils.invokeMethod(clazz, "getInstance");
            return (Boolean)ReflectionUtils.invokeMethod(console, "isAnsiEnabled");
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public void setPlainOutput(boolean isPlain) {
        try {
            Class<?> clazz = this.classLoader.loadClass("grails.build.logging.GrailsConsole");
            Object console = ReflectionUtils.invokeMethod(clazz, "getInstance");
            ReflectionUtils.invokeMethod(console, "setAnsiEnabled", new Class[]{Boolean.TYPE}, new Object[]{!isPlain});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isInteractiveMode() {
        String args = this.getArgs();
        return args == null || !args.matches("(^|.*\\s)--?non-interactive.*");
    }

    public int launch() throws Exception {
        Object[] params;
        Class[] paramTypes;
        Object grailsScriptRunner = this.classLoader.loadClass("org.codehaus.groovy.grails.cli.GrailsScriptRunner").getDeclaredConstructor(this.settings.getClass()).newInstance(this.settings);
        ReflectionUtils.invokeMethod(grailsScriptRunner, "setInteractive", new Class[]{Boolean.TYPE}, new Object[]{this.isInteractiveMode()});
        if (this.getEnv() == null) {
            paramTypes = new Class[]{String.class, String.class};
            params = new Object[]{this.getScriptName(), this.getArgs()};
        } else {
            paramTypes = new Class[]{String.class, String.class, String.class};
            params = new Object[]{this.getScriptName(), this.getArgs(), this.getEnv()};
        }
        return (Integer)ReflectionUtils.invokeMethod(grailsScriptRunner, "executeCommand", paramTypes, params);
    }
}

